/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.MrMagicalCart.cartaddon.ModMain;
import net.MrMagicalCart.cartaddon.config.CartGeneralConfig;
import net.MrMagicalCart.cartaddon.config.CartWorldEventsConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="cartaddon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CartCommonConfig {
    public static final Path CONFIG_PATH = Paths.get("config", "cartaddon-common.toml");
    public static final CartCommonConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public static void save() {
        ModMain.LOGGER.warn("save() method got accessed server side! This is bad!");
    }

    public void clearCachedLists() {
    }

    public CartCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        CartGeneralConfig.ALLOW_CHEAPPO.createValue(builder);
        builder.push("Spawn Chances");
        CartWorldEventsConfig.REV_GRUNT_SPAWN_CHANCE.createValue(builder);
        CartWorldEventsConfig.REV_OFFICER_SPAWN_CHANCE.createValue(builder);
        CartWorldEventsConfig.REV_COMMANDER_SPAWN_CHANCE.createValue(builder);
        CartWorldEventsConfig.PX_II_SPAWN_CHANCE.createValue(builder);
    }

    public boolean cheappoEnabled() {
        return (Boolean)CartGeneralConfig.ALLOW_CHEAPPO.get();
    }

    public double getPXIISpawnChance() {
        return (Double)CartWorldEventsConfig.PX_II_SPAWN_CHANCE.get();
    }

    public double getRevCommanderSpawnChance() {
        return (Double)CartWorldEventsConfig.REV_COMMANDER_SPAWN_CHANCE.get();
    }

    public double getRevOfficerSpawnChance() {
        return (Double)CartWorldEventsConfig.REV_OFFICER_SPAWN_CHANCE.get();
    }

    public double getRevGruntSpawnChance() {
        return (Double)CartWorldEventsConfig.REV_GRUNT_SPAWN_CHANCE.get();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CartCommonConfig::new);
        SPEC = (ForgeConfigSpec)pair.getRight();
        INSTANCE = (CartCommonConfig)pair.getLeft();
    }
}

