/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.challenges.marines;

import java.util.HashSet;
import java.util.Set;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SmokerEntity;
import net.MrMagicalCart.cartaddon.init.CartArmors;
import net.MrMagicalCart.cartaddon.init.CartEntities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.challenges.arenas.MarineSmallBaseSimpleArena;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.DyeableModSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class SmokerChallenge
extends Challenge {
    private static final String TITLE = WyRegistry.registerName((String)"challenge.mineminenomi.marines.smoker", (String)"Smoker");
    public static final String OBJECTIVE = WyRegistry.registerName((String)"challenge.mineminenomi.marines.smoker.objective", (String)"Defeat Smoker");
    public static final ResourceLocation REWARD = new ResourceLocation("mineminenomi", "rewards/smoker");
    public static final ChallengeCore<SmokerChallenge> INSTANCE = new ChallengeCore.Builder("smoker", TITLE, OBJECTIVE, ModNPCGroups.MARINES, SmokerChallenge::new).setDifficulty(ChallengeDifficulty.STANDARD).setDifficultyStars(5).setRewardsFactor(3.0f).addArena(ArenaStyle.SIMPLE, (ChallengeArena)MarineSmallBaseSimpleArena.INSTANCE, MarineSmallBaseSimpleArena::getChallengerSpawnPos, MarineSmallBaseSimpleArena::getEnemySpawnPos).setEnemySpawns(SmokerChallenge::setEnemeySpawns).setTargetShowcase(new ChallengeCore.ITargetShowcase[]{SmokerChallenge::createSmokerShowcase}).setTimeLimit(10).setOrder(ModChallenges.Order.MR_0).setRewards(REWARD).build();

    public SmokerChallenge(ChallengeCore core) {
        super(core);
    }

    public static Set<ChallengeArena.EnemySpawn> setEnemeySpawns(InProgressChallenge challenge, ChallengeArena.SpawnPosition[] spawns) {
        HashSet<ChallengeArena.EnemySpawn> set = new HashSet<ChallengeArena.EnemySpawn>();
        SmokerEntity boss = new SmokerEntity(challenge);
        set.add(new ChallengeArena.EnemySpawn((LivingEntity)boss, spawns[0]));
        return set;
    }

    public static LivingEntity createSmokerShowcase(World world) {
        SmokerEntity entity = (SmokerEntity)((EntityType)CartEntities.SMOKER.get()).func_200721_a(world);
        ItemStack capeStack = new ItemStack((IItemProvider)CartArmors.R_MARINE_CAPTAIN_CAPE.get());
        capeStack.func_190925_c("display").func_74768_a("color", WyHelper.hexToRGB((String)"#4a583c").getRGB());
        entity.func_184201_a(EquipmentSlotType.CHEST, capeStack);
        entity.func_184201_a(EquipmentSlotType.MAINHAND, ((DyeableModSwordItem)ModWeapons.JITTE.get()).func_190903_i());
        entity.func_184201_a(EquipmentSlotType.HEAD, ((Item)ModItems.THREE_CIGARS.get()).func_190903_i());
        return entity;
    }
}

