/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;

public class BaltigoSimpleArena
extends ChallengeArena {
    public static final BaltigoSimpleArena INSTANCE = new BaltigoSimpleArena();
    private static final int ARENA_X_SIZE_RADIUS = 70;
    private static final int ARENA_Z_SIZE_RADIUS = 50;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private static final int ARENA_X_SIZE = 140;
    private static final int ARENA_Z_SIZE = 100;
    private static final int GROUND_LEVEL = 30;
    private final WeightedList<BlockState> floorBlocks = new WeightedList(new Object[]{Blocks.field_150348_b.func_176223_P(), 100, Blocks.field_196656_g.func_176223_P(), 50, Blocks.field_150351_n.func_176223_P(), 40, Blocks.field_150347_e.func_176223_P(), 20, Blocks.field_196696_di.func_176223_P(), 5});
    private static final BlockProtectionRule ONLY_AIR_AND_WATER = new BlockProtectionRule.Builder(new BlockProtectionRule[0]).addApprovedMaterials(new Material[]{Material.field_151579_a, Material.field_151586_h}).build();

    private BaltigoSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(30);
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), (BlockPos)bottomLayer.func_177984_a(), (int)139, (int)30, (int)99, (BlockState)Blocks.field_150355_j.func_176223_P(), (int)0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), (BlockPos)bottomLayer.func_177981_b(3).func_177982_a(-70, 0, 0), (int)98, (int)6, this.floorBlocks, (int)0, (BlockProtectionRule)ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), (BlockPos)bottomLayer.func_177981_b(9).func_177982_a(-70, 0, 0), (int)95, (int)8, this.floorBlocks, (int)0, (BlockProtectionRule)ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), (BlockPos)bottomLayer.func_177977_b().func_177982_a(-70, 0, 0), (int)90, (int)30, this.floorBlocks, (int)0, (BlockProtectionRule)ONLY_AIR_AND_WATER));
        blocks.addAll(StructuresHelper.createCenteredFilledCircle((World)challenge.getShard(), (BlockPos)groundLayer.func_177977_b().func_177982_a(-70, 0, 0), (int)89, (int)2, this.floorBlocks, (int)0, (BlockProtectionRule)ONLY_AIR_AND_WATER));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-70, -50, -50, 70, 50, 50);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 14 - (posId + 1), challenge.getArenaPos().func_177956_o() - 17, challenge.getArenaPos().func_177952_p());
        return new ChallengeArena.SpawnPosition(pos, -90.0f, 23.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 10, challenge.getArenaPos().func_177956_o() - 17, challenge.getArenaPos().func_177952_p());
        return ChallengesHelper.get4DefaultSpawnPoints((BlockPos)pos, (float)90.0f, (float)-23.0f);
    }
}

