/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.cartapi;

import com.mojang.datafixers.types.Type;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.MrMagicalCart.cartaddon.api.CartRegistries;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CartRegistry {
    private static HashMap<String, String> langMap = new HashMap();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"cartaddon");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cartaddon");
    public static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"cartaddon");
    public static final DeferredRegister<AbilityCore<?>> ABILITIES = DeferredRegister.create((IForgeRegistry)ModRegistries.ABILITIES, (String)"cartaddon");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"cartaddon");
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"cartaddon");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"cartaddon");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"cartaddon");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"cartaddon");
    public static final DeferredRegister<QuestId<?>> QUESTS = DeferredRegister.create((IForgeRegistry)ModRegistries.QUESTS, (String)"cartaddon");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"cartaddon");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"cartaddon");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"cartaddon");
    public static final DeferredRegister<ChallengeCore<?>> CHALLENGES = DeferredRegister.create((IForgeRegistry)ModRegistries.CHALLENGES, (String)"cartaddon");
    public static final DeferredRegister<ParticleEffect<?>> PARTICLE_EFFECTS = DeferredRegister.create((IForgeRegistry)ModRegistries.PARTICLE_EFFECTS, (String)"cartaddon");
    public static final DeferredRegister<MorphInfo> MORPHS = DeferredRegister.create((IForgeRegistry)ModRegistries.MORPHS, (String)"cartaddon");
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"cartaddon");

    public static HashMap<String, String> getLangMap() {
        return langMap;
    }

    public static String registerName(String key, String localizedName) {
        CartRegistry.getLangMap().put(key, localizedName);
        return key;
    }

    public static TranslationTextComponent registerTextComponent(String key, String localizedName) {
        return new TranslationTextComponent(CartRegistry.registerName(key, localizedName));
    }

    public static <T extends MorphInfo> RegistryObject<T> registerMorph(String resourceName, Supplier<T> morph) {
        RegistryObject reg = MORPHS.register(resourceName, morph);
        return reg;
    }

    public static <T extends Biome> RegistryObject<T> registerBiome(String localizedName, Supplier<T> biome) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("biome.cartaddon." + resourceName, localizedName);
        RegistryObject reg = BIOMES.register(resourceName, biome);
        return reg;
    }

    public static <T extends ParticleEffect<?>> RegistryObject<T> registerParticleEffect(String localizedName, Supplier<T> attr) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        RegistryObject reg = PARTICLE_EFFECTS.register("particle_effect.cartaddon." + resourceName, attr);
        return reg;
    }

    public static RegistryObject<Attribute> registerAttribute(String localizedName, Supplier<Attribute> attr) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("attribute.name.generic.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ATTRIBUTES.register("generic." + resourceName, attr);
        return reg;
    }

    public static <T extends ParticleType<?>> RegistryObject<T> registerParticleType(String localizedName, Supplier<T> type) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        RegistryObject reg = PARTICLE_TYPES.register(resourceName, type);
        return reg;
    }

    public static <T extends Feature<?>> RegistryObject<T> registerFeature(String localizedName, Supplier<T> feature) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        RegistryObject reg = FEATURES.register(resourceName, feature);
        return reg;
    }

    public static <T extends Effect> RegistryObject<T> registerEffect(String localizedName, Supplier<T> effect) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        return CartRegistry.registerEffect(localizedName, resourceName, effect);
    }

    public static <T extends Effect> RegistryObject<T> registerEffect(String localizedName, String resourceKey, Supplier<T> effect) {
        String resourceName = WyHelper.getResourceName((String)resourceKey);
        CartRegistry.getLangMap().put("effect.cartaddon." + resourceName, localizedName);
        RegistryObject reg = EFFECTS.register(resourceName, effect);
        return reg;
    }

    public static <T extends Enchantment> RegistryObject<T> registerEnchantment(String localizedName, Supplier<T> enchantment) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("enchantment.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ENCHANTMENTS.register(resourceName, enchantment);
        return reg;
    }

    public static <T extends Quest> QuestId<T> registerQuest(QuestId<T> quest) {
        String resourceName = WyHelper.getResourceName((String)quest.getName());
        CartRegistry.getLangMap().put("quest.cartaddon." + resourceName, quest.getName());
        ResourceLocation key = new ResourceLocation("cartaddon", resourceName);
        RegistryObject ret = RegistryObject.of((ResourceLocation)key, (IForgeRegistry)ModRegistries.QUESTS);
        if (!QUESTS.getEntries().contains(ret)) {
            QUESTS.register(resourceName, () -> quest);
        }
        return quest;
    }

    public static <T extends IAbility> AbilityCore<T> registerAbility(AbilityCore<T> core) {
        String resourceName = WyHelper.getResourceName((String)core.getId());
        ResourceLocation key = new ResourceLocation("cartaddon", resourceName);
        CartRegistry.getLangMap().put("ability.cartaddon." + resourceName, core.getUnlocalizedName());
        RegistryObject ret = RegistryObject.of((ResourceLocation)key, CartRegistries.ABILITIES);
        if (!ABILITIES.getEntries().contains(ret)) {
            ABILITIES.register(resourceName, () -> core);
            if (core.getIcon() == null) {
                core.setIcon(new ResourceLocation(key.func_110624_b(), "textures/abilities/" + key.func_110623_a() + ".png"));
            }
        }
        return core;
    }

    public static RegistryObject<SoundEvent> registerSound(String localizedName) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("cartaddon.subtitle." + resourceName, localizedName);
        SoundEvent sound = new SoundEvent(new ResourceLocation("cartaddon", resourceName));
        RegistryObject reg = SOUNDS.register(resourceName, () -> sound);
        return reg;
    }

    public static <T extends Item> RegistryObject<T> registerItem(String localizedName, Supplier<T> item) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("item.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ITEMS.register(resourceName, item);
        return reg;
    }

    public static RegistryObject<ForgeSpawnEggItem> registerSpawnEggItem(String localizedEntityName, Supplier<ForgeSpawnEggItem> supp) {
        String entityResName = WyHelper.getResourceName((String)localizedEntityName);
        String resourceName = entityResName + "_spawn_egg";
        String localizedName = "Spawn " + localizedEntityName;
        CartRegistry.getLangMap().put("item.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ITEMS.register(resourceName, supp);
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block) {
        return CartRegistry.registerBlock(localizedName, block, (ItemGroup)null);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, @Nullable ItemGroup tab) {
        Item.Properties blockItemProps = new Item.Properties();
        if (tab != null) {
            blockItemProps.func_200916_a(tab);
        }
        return CartRegistry.registerBlock(localizedName, block, blockItemProps);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, Item.Properties props) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("block.cartaddon." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        CartRegistry.registerItem(localizedName, () -> new BlockItem((Block)reg.get(), props));
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, Function<T, BlockItem> blockItemFunc) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("block.cartaddon." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        CartRegistry.registerItem(localizedName, () -> (BlockItem)blockItemFunc.apply(reg.get()));
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlockOnly(String localizedName, Supplier<T> block) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("block.cartaddon." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        return reg;
    }

    public static <C extends Container> RegistryObject<ContainerType<C>> registerContainer(String localizedName, IContainerFactory<C> containerFactory) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("container.cartaddon." + resourceName, localizedName);
        RegistryObject reg = CONTAINER_TYPES.register(resourceName, () -> IForgeContainerType.create((IContainerFactory)containerFactory));
        return reg;
    }

    public static RegistryObject<TileEntityType<?>> registerTileEntity(String localizedName, Supplier<TileEntity> factory, Block ... blocks) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        TileEntityType type = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a((Type)null);
        RegistryObject reg = TILE_ENTITIES.register(resourceName, () -> type);
        return reg;
    }

    public static <T extends Entity> EntityType.Builder<T> createFastEntityType(EntityType.IFactory<T> factory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC);
        builder.setTrackingRange(128).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> EntityType.Builder createEntityType(EntityType.IFactory<T> factory) {
        return CartRegistry.createEntityType(factory, EntityClassification.MISC);
    }

    public static <T extends Entity> EntityType.Builder createEntityType(EntityType.IFactory<T> factory, EntityClassification classification) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setUpdateInterval(1).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String localizedName, Supplier<EntityType<T>> supp) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("entity.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ENTITY_TYPES.register(resourceName, supp);
        return reg;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String localizedName, String resourceName, Supplier<EntityType<T>> supp) {
        CartRegistry.getLangMap().put("entity.cartaddon." + resourceName, localizedName);
        RegistryObject reg = ENTITY_TYPES.register(resourceName, supp);
        return reg;
    }

    public static <T extends Entity> void registerEntityType(EntityType<T> type, String localizedName) {
        String resourceName = WyHelper.getResourceName((String)localizedName);
        CartRegistry.getLangMap().put("entity.cartaddon." + resourceName, localizedName);
    }
}

