/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.api.helpers;

import net.MrMagicalCart.cartaddon.abilities.blacklegextra.CartPartyTableKickCourseAbility;
import net.MrMagicalCart.cartaddon.abilities.bludgeon.WhirlingMaceAbility;
import net.MrMagicalCart.cartaddon.abilities.brawlerextra.ReworkedSpinningBrawlAbility;
import net.MrMagicalCart.cartaddon.abilities.nitoryu.SaiKuruAbility;
import net.MrMagicalCart.cartaddon.abilities.oni.ViciousRoarAbility;
import net.MrMagicalCart.cartaddon.abilities.swordsmenextra.ReworkedOTatsumakiAbility;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.BludgeonTrainerEntity;
import net.MrMagicalCart.cartaddon.init.CartI18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SpinningBrawlAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.KamieAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.items.weapons.AbilitySwordItem;

public class AbilityLimits {
    public static AbilityUseResult usingBrawler(LivingEntity entity, IAbility ability) {
        boolean spinActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        ReworkedSpinningBrawlAbility spinningBrawlAbility = (ReworkedSpinningBrawlAbility)abilityProps.getEquippedAbility(ReworkedSpinningBrawlAbility.INSTANCE);
        boolean bl = spinActive = spinningBrawlAbility != null && (spinningBrawlAbility.isContinuous() || spinningBrawlAbility.isCharging());
        if (spinActive) {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{ability.getDisplayName().getString(), SpinningBrawlAbility.INSTANCE.getUnlocalizedName()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    public static boolean cancelBrawler(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        ReworkedSpinningBrawlAbility spinningBrawlAbility = (ReworkedSpinningBrawlAbility)abilityProps.getEquippedAbility(ReworkedSpinningBrawlAbility.INSTANCE);
        boolean spinActive = spinningBrawlAbility != null && (spinningBrawlAbility.isContinuous() || spinningBrawlAbility.isCharging());
        return spinActive;
    }

    public static boolean cancelOtatsumaki(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        ReworkedOTatsumakiAbility oTatsumakiAbility = (ReworkedOTatsumakiAbility)abilityProps.getEquippedAbility(ReworkedOTatsumakiAbility.INSTANCE);
        boolean spinActive = oTatsumakiAbility != null && (oTatsumakiAbility.isContinuous() || oTatsumakiAbility.isCharging());
        return spinActive;
    }

    public static boolean cancelWhirlingMace(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        WhirlingMaceAbility whirlingMaceAbility = (WhirlingMaceAbility)abilityProps.getEquippedAbility(WhirlingMaceAbility.INSTANCE);
        boolean spinActive = whirlingMaceAbility != null && (whirlingMaceAbility.isContinuous() || whirlingMaceAbility.isCharging());
        return spinActive;
    }

    public static boolean cancelPartyTable(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        CartPartyTableKickCourseAbility partyTableKickCourseAbility = (CartPartyTableKickCourseAbility)abilityProps.getEquippedAbility(CartPartyTableKickCourseAbility.INSTANCE);
        boolean spinActive = partyTableKickCourseAbility != null && (partyTableKickCourseAbility.isContinuous() || partyTableKickCourseAbility.isCharging());
        return spinActive;
    }

    public static boolean cancelSaiKuru(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        SaiKuruAbility saiKuruAbility = (SaiKuruAbility)abilityProps.getEquippedAbility(SaiKuruAbility.INSTANCE);
        boolean spinActive = saiKuruAbility != null && (saiKuruAbility.isContinuous() || saiKuruAbility.isCharging());
        return spinActive;
    }

    public static boolean cancelVicousRoar(LivingEntity entity) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        ViciousRoarAbility viciousRoarAbility = (ViciousRoarAbility)abilityProps.getEquippedAbility(ViciousRoarAbility.INSTANCE);
        boolean roarActive = viciousRoarAbility != null && (viciousRoarAbility.isContinuous() || viciousRoarAbility.isCharging());
        return roarActive;
    }

    public static AbilityUseResult fruitless(LivingEntity entity, IAbility ability) {
        if (DevilFruitCapability.get((LivingEntity)entity).hasAnyDevilFruit()) {
            TranslationTextComponent text = new TranslationTextComponent(CartI18n.ABILITY_REQUIRES_FRUITLESS, new Object[]{ability.getDisplayName().getString()});
            return AbilityUseResult.fail((ITextComponent)text);
        }
        return AbilityUseResult.success();
    }

    public static boolean ateFruit(LivingEntity entity, IAbility ability) {
        return DevilFruitCapability.get((LivingEntity)entity).hasAnyDevilFruit();
    }

    public static AbilityUseResult requiresBluntWeapon(LivingEntity entity, IAbility ability) {
        boolean hasBluntInHand;
        boolean bl = hasBluntInHand = ItemsHelper.isBlunt((ItemStack)entity.func_184614_ca()) || entity.func_184614_ca().func_77973_b() instanceof AbilitySwordItem;
        if (hasBluntInHand || entity instanceof BludgeonTrainerEntity) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_BLUNT));
    }

    public static boolean canUseBlunt(LivingEntity entity) {
        boolean hasBluntInHand;
        boolean bl = hasBluntInHand = ItemsHelper.isBlunt((ItemStack)entity.func_184614_ca()) || entity.func_184614_ca().func_77973_b() instanceof AbilitySwordItem;
        return hasBluntInHand || entity instanceof BludgeonTrainerEntity;
    }

    public static boolean isDry(LivingEntity entity, IAbility ability) {
        return !entity.func_70026_G();
    }

    public static AbilityUseResult requiresSantoryu(LivingEntity entity, IAbility ability) {
        if (AbilityLimits.hasThirdSword(entity)) {
            if (AbilityLimits.canUseNitoryu(entity)) {
                if (AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
                    return AbilityUseResult.success();
                }
                return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_BLUNT));
            }
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_BLUNT));
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_BLUNT));
    }

    public static boolean canUseSantoryu(LivingEntity entity) {
        if (AbilityLimits.hasThirdSword(entity)) {
            if (AbilityLimits.canUseNitoryu(entity)) {
                if (AbilityHelper.canUseSwordsmanAbilities((LivingEntity)entity)) {
                    return true;
                }
                entity.func_145747_a((ITextComponent)new StringTextComponent("You need a sword to use this ability!"), entity.func_110124_au());
                return false;
            }
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a sword in your off-hand!"), entity.func_110124_au());
            return false;
        }
        entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding a sword in your first hot-bar slot!"), entity.func_110124_au());
        return false;
    }

    public static boolean hasThirdSword(LivingEntity entity) {
        ItemStack hand;
        ItemStack slotOne;
        if (!(entity instanceof PlayerEntity)) {
            return true;
        }
        boolean hasSwordInHand = ItemsHelper.isSword((ItemStack)entity.func_184614_ca());
        boolean hasSwordInFirstSlot = ItemsHelper.isSword((ItemStack)((PlayerEntity)entity).field_71071_by.func_70301_a(0));
        return hasSwordInHand && hasSwordInFirstSlot && (slotOne = ((PlayerEntity)entity).field_71071_by.func_70301_a(0)) != (hand = entity.func_184614_ca());
    }

    public static boolean canUseNitoryu(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return true;
        }
        return ItemsHelper.isSword((ItemStack)entity.func_184592_cb());
    }

    public static boolean hasKamie(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        KamieAbility kamieAbility = (KamieAbility)props.getEquippedAbility(KamieAbility.INSTANCE);
        return kamieAbility != null && kamieAbility.isContinuous();
    }

    public static boolean canUseTwinBarrel(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return true;
        }
        return ItemsHelper.isBow((ItemStack)entity.func_184592_cb()) && ItemsHelper.isBow((ItemStack)entity.func_184614_ca());
    }

    public static AbilityUseResult requiresTwinBarrel(LivingEntity entity, IAbility ability) {
        boolean hasGun;
        boolean bl = hasGun = ItemsHelper.isBow((ItemStack)entity.func_184614_ca()) && ItemsHelper.isBow((ItemStack)entity.func_184592_cb());
        if (hasGun) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(CartI18n.ABILITY_MESSAGE_NEED_TWIN_BARREL));
    }

    public static AbilityUseResult requiresGun(LivingEntity entity, IAbility ability) {
        boolean hasGun = ItemsHelper.isBow((ItemStack)entity.func_184614_ca());
        if (hasGun) {
            return AbilityUseResult.success();
        }
        return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(CartI18n.ABILITY_MESSAGE_NEED_GUN));
    }
}

