/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.yoru;

import java.util.List;
import net.MrMagicalCart.cartaddon.entities.projectiles.yoru.BlackBladeWildSlashProjectile;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackBladeWildSlashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"black_blade_wild_slash", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user slashes the air rapidly, dealing damage to targets in front of them. At the end of this ability, the user fires a slash at their target.", null)});
    private static final float COOLDOWN = 300.0f;
    private static final int CHARGE_TIME = 30;
    private static final float DAMAGE = 5.0f;
    private static final float RANGE = 4.0f;
    private final Interval damageInterval = new Interval(5);
    public static final AbilityCore<BlackBladeWildSlashAbility> INSTANCE = new AbilityCore.Builder("Black Blade: Wild Slash", AbilityCategory.EQUIPMENT, BlackBladeWildSlashAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)5.0f, (float)30.0f), ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)4.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setUnlockCheck(BlackBladeWildSlashAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public BlackBladeWildSlashAbility(AbilityCore<BlackBladeWildSlashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.chargeComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent});
        this.addUseEvent(this::onUseEvent);
        super.addEquipEvent(this::equipEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_184614_ca().func_77973_b().equals(ModWeapons.YORU.get())) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You must be holding Yoru to use this move!"), entity.func_110124_au());
            return;
        }
        this.chargeComponent.startCharging(entity, 30.0f);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        if (this.damageInterval.canTick()) {
            List targets = this.rangeComponent.getTargetsInLine(entity, 6.0f, 4.0f);
            for (LivingEntity target : targets) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0, false, false));
                if (this.hitTrackerComponent.canHit((Entity)target) && this.dealDamageComponent.hurtTarget(entity, target, 5.0f)) {
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
                }
                this.hitTrackerComponent.clearHits();
            }
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)4.0);
        double x = mop.func_216347_e().field_72450_a + WyHelper.randomDouble();
        double z = mop.func_216347_e().field_72449_c + WyHelper.randomDouble();
        double y = mop.func_216347_e().field_72448_b + WyHelper.randomDouble();
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BLACK_BLADE_WILD_SLASH.get()), (Entity)entity, (double)x, (double)y, (double)z);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BLACK_BLADE_WILD_SLASH.get()), (Entity)entity, (double)x, (double)y, (double)z);
        WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.BLACK_BLADE_WILD_SLASH.get()), (Entity)entity, (double)x, (double)y, (double)z);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.LIGHTNING_TELEPORT.get(), SoundCategory.PLAYERS, 3.0f, 1.25f);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CANNON_SLASH, 7);
        this.projectileComponent.shoot(entity, 3.5f, 1.0f);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        this.hitTrackerComponent.clearHits();
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private BlackBladeWildSlashProjectile createProjectile(LivingEntity entity) {
        BlackBladeWildSlashProjectile proj = new BlackBladeWildSlashProjectile(entity.field_70170_p, entity, this);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        return BlackBladeWildSlashAbility.hasItem(entity);
    }

    private static boolean hasItem(LivingEntity entity) {
        for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
            if (!itemStack.func_77973_b().equals(ModWeapons.YORU.get())) continue;
            return true;
        }
        return false;
    }
}

