/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.wapu;

import net.MrMagicalCart.cartaddon.init.CartSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WarpAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"warp", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user warps wherever they are looking.", null)});
    private static final float MAX_TELEPORT_DISTANCE = 80.0f;
    private static final int COOLDOWN = 160;
    public static final AbilityCore<WarpAbility> INSTANCE = new AbilityCore.Builder("Warp", AbilityCategory.DEVIL_FRUITS, WarpAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)160.0f, (float)360.0f)}).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private boolean hasFallDamage = true;

    public WarpAbility(AbilityCore<WarpAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        float percentHp = entity.func_110143_aJ() * 100.0f / entity.func_110138_aP();
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)entity, (double)80.0);
        BlockPos blockpos = mop != null && mop.func_216346_c() != RayTraceResult.Type.MISS ? WyHelper.getClearPositionForPlayer((LivingEntity)entity, (BlockPos)mop.func_216350_a()) : WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)80.0f);
        if (blockpos == null) {
            blockpos = WyHelper.rayTraceBlockSafe((LivingEntity)entity, (float)80.0f);
        }
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)CartSounds.WAPU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        entity.func_184210_p();
        entity.func_223102_j((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)CartSounds.WAPU_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.hasFallDamage = false;
        this.cooldownComponent.startCooldown(entity, 160.0f + 2.0f * (100.0f - percentHp));
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }
}

