/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.wapu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class TagAlongAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"tag_along", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user grabs a target allowing them to travel with the user for a short period of time.", null)});
    private static final TargetsPredicate TARGETS_CHECK = new TargetsPredicate().testFriendlyFaction();
    private static final int COOLDOWN = 250;
    private static final int CHARGE_TIME = 70;
    private static final int PULL_TIME = 200;
    public static final AbilityCore<TagAlongAbility> INSTANCE = new AbilityCore.Builder("Tag Along", AbilityCategory.DEVIL_FRUITS, TagAlongAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)70.0f), CooldownComponent.getTooltip((float)250.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(70, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final Interval particleInterval = new Interval(6);

    public TagAlongAbility(AbilityCore<TagAlongAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.chargeComponent, this.animationComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (this.continuousComponent.isContinuous()) {
                this.grabComponent.release(entity);
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                this.grabComponent.triggerPulling(entity);
            } else {
                this.cooldownComponent.startCooldown(entity, 15.0f);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
            if (this.grabComponent.grabManually(entity, target)) {
                this.grabComponent.startPulling(entity);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
            return false;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 70.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                this.grabComponent.release(entity);
            }
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.cooldownComponent.startCooldown(entity, 250.0f);
            }
        }
    }

    public void onChargeStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
        this.particleInterval.restartIntervalToZero();
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!(entity.field_70170_p.field_72995_K || !super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity))) {
            this.chargeComponent.stopCharging(entity);
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            LivingEntity target = this.grabComponent.getGrabbedEntity();
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 1, false, false));
            this.grabComponent.release(entity);
            this.animationComponent.stop(entity);
        }
        this.cooldownComponent.startCooldown(entity, 250.0f);
    }
}

