/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.wapu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SwitchUpAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"switch_up", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user switches places with the entity they are looking at.", null)});
    private static final float MAX_TELEPORT_DISTANCE = 80.0f;
    private static final int COOLDOWN = 200;
    public static final AbilityCore<SwitchUpAbility> INSTANCE = new AbilityCore.Builder("Switch Up", AbilityCategory.DEVIL_FRUITS, SwitchUpAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)80.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private boolean hasFallDamage = true;

    public SwitchUpAbility(AbilityCore<SwitchUpAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        boolean hadTarget = false;
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)80.0);
        if (mop instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
            Entity target = entityRayTraceResult.func_216348_a();
            float[] afloat = new float[]{(float)entity.func_226277_ct_(), (float)entity.func_226278_cu_(), (float)entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A};
            entity.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
            entity.func_225653_b_(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            target.func_70012_b((double)afloat[0], (double)afloat[1], (double)afloat[2], afloat[3], afloat[4]);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, target.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            hadTarget = true;
        }
        if (hadTarget) {
            this.cooldownComponent.startCooldown(entity, 200.0f);
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }
}

