/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.wapu;

import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CounterShiftAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"counter_shift", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user blocks an incoming hit then teleports behind the attacker.", null)});
    private static final float HOLD_TIME = 30.0f;
    private static final float MIN_COOLDOWN = 300.0f;
    private static final float MAX_COOLDOWN = 400.0f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<CounterShiftAbility> INSTANCE = new AbilityCore.Builder("Counter Shift", AbilityCategory.DEVIL_FRUITS, CounterShiftAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f), ContinuousComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)300.0f, (float)400.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::onTickContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTakenEvent, DamageTakenComponent.DamageState.ATTACK);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);

    public CounterShiftAbility(AbilityCore<CounterShiftAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.animationComponent, this.poolComponent, this.damageTakenComponent, this.dealDamageComponent});
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 30.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 1, false, false));
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.5);
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.COUNTER_SHIFT.get()), (Entity)entity, (double)(entity.func_226277_ct_() + look.field_72450_a), (double)(entity.func_226278_cu_() + 0.25 + look.field_72448_b), (double)(entity.func_226281_cx_() + look.field_72449_c));
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        if (!this.continuousComponent.isContinuous()) {
            return damage;
        }
        Entity sourceEntity = source.func_76346_g();
        if (sourceEntity == null) {
            return damage;
        }
        if (sourceEntity instanceof LivingEntity || sourceEntity instanceof AbilityProjectileEntity) {
            LivingEntity target = (LivingEntity)sourceEntity;
            if (sourceEntity instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)sourceEntity).func_234616_v_() != null && ((AbilityProjectileEntity)sourceEntity).func_234616_v_().func_70089_S()) {
                target = ((AbilityProjectileEntity)sourceEntity).getThrower();
            }
            this.dealDamageComponent.hurtTarget(entity, target, 15.0f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f);
            entity.field_70170_p.func_184133_a((PlayerEntity)null, target.func_233580_cy_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.75f);
            Vector3d targetLook = VectorHelper.calculateViewVectorFromBodyRot((float)target.field_70125_A, (float)target.field_70761_aq).func_216372_d(-2.0, 0.0, -2.0);
            Vector3d newPos = target.func_213303_ch().func_178787_e(targetLook);
            if (!(target instanceof PlayerEntity)) {
                if (WyHelper.isInChallengeDimension((World)entity.field_70170_p)) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 60, 3, false, false));
                } else {
                    entity.func_195064_c(new EffectInstance(Effects.field_76429_m, 40, 2, false, false));
                }
            }
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 20, 0, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 20, 0, false, false));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.GEPPO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + 0.5), (double)entity.func_226281_cx_());
            entity.func_223102_j(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
            entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0));
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
        this.continuousComponent.stopContinuity(entity);
        return 0.0f;
    }
}

