/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.uoseriyu.UoSeiryuHelper;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TatsumakiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"tatsumaki", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user spins around, creating a dust twister that makes opponents unable to move.", null)});
    private static final int COOLDOWN = 500;
    private static final int HOLD_TIME = 120;
    private static final int DMG = 10;
    public static final AbilityCore<TatsumakiAbility> INSTANCE = new AbilityCore.Builder("Tatsumaki", AbilityCategory.DEVIL_FRUITS, TatsumakiAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)15.0f), ContinuousComponent.getTooltip((float)120.0f), CooldownComponent.getTooltip((float)500.0f), RangeComponent.getTooltip((float)8.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).build();
    private final ContinuousComponent continuityComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SEIRYU_FLY.get(), new MorphInfo[0]);
    private Interval particleInterval = new Interval(15);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public TatsumakiAbility(AbilityCore<TatsumakiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.continuityComponent, this.dealDamageComponent, this.requireMorphComponent});
        super.addCanUseCheck(UoSeiryuHelper::usingKaenDaiko);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.triggerContinuity(entity, 120.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.YAW_SPIN);
        this.particleInterval.restartIntervalToZero();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.TATSUMAKI.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
        if (entity.func_70089_S()) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(2.0, 2.0, 2.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
            AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
            source.setUnavoidable();
            source.setPiercing(0.75f);
            List list = WyHelper.getNearbyLiving((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)8.0, (double)30.0, (double)8.0, (Predicate)ModEntityPredicates.getEnemyFactions((LivingEntity)entity));
            for (LivingEntity target : list) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 4));
                target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 4));
                this.dealDamageComponent.hurtTarget(entity, target, 15.0f, (DamageSource)source);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 500.0f);
    }
}

