/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import java.util.List;
import net.MrMagicalCart.cartaddon.abilities.uoseriyu.KaenDaikoAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class ShoryuKaenHakkeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"shoryu_kaen_hakke", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user uses their flaming body to ram into their target, dealing massive damage.", null)});
    private static final int HOLD_TIME = 60;
    private static final int COOLDOWN = 1800;
    private static final float RANGE = 8.0f;
    private static final float DAMAGE = 100.0f;
    public static final AbilityCore<ShoryuKaenHakkeAbility> INSTANCE = new AbilityCore.Builder("Shoryu Kaen Hakke", AbilityCategory.DEVIL_FRUITS, ShoryuKaenHakkeAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)100.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)1800.0f), RangeComponent.getTooltip((float)10.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceType(new SourceType[]{SourceType.PHYSICAL}).setSourceElement(SourceElement.FIRE).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.KAEN_DAIKO.get(), new MorphInfo[0]);

    public ShoryuKaenHakkeAbility(AbilityCore<ShoryuKaenHakkeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.hitTrackerComponent, this.requireMorphComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::hasKaen);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.KAEN_DAIKO.get()) {
            this.continuousComponent.triggerContinuity(entity, 60.0f);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_70089_S()) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(1.6, 1.6, 1.6);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
            AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
            source.setUnavoidable();
            source.func_76361_j();
            List targets = this.rangeComponent.getTargetsInArea(entity, 8.0f);
            for (LivingEntity target : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 100.0f, (DamageSource)source)) continue;
                target.func_70015_d(10);
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, (World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (float)28.0f);
        explosion.setStaticDamage(0.0f);
        explosion.setDamageEntities(false);
        explosion.setDamageOwner(false);
        explosion.setFireAfterExplosion(true);
        explosion.doExplosion();
        this.cooldownComponent.startCooldown(entity, 1800.0f);
    }

    private AbilityUseResult hasKaen(LivingEntity entity, IAbility ability) {
        boolean kaenActive;
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)entity);
        KaenDaikoAbility kaenDaikoAbility = (KaenDaikoAbility)abilityProps.getEquippedAbility(KaenDaikoAbility.INSTANCE);
        boolean bl = kaenActive = kaenDaikoAbility != null && kaenDaikoAbility.isContinuous();
        if (kaenActive) {
            return AbilityUseResult.success();
        }
        TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MISSING_DEPENDENCY_SINGLE, new Object[]{this.getDisplayName().getString(), KaenDaikoAbility.INSTANCE.getUnlocalizedName()});
        return AbilityUseResult.fail((ITextComponent)text);
    }
}

