/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.uoseriyu.SeiryuFlightPassiveAbility;
import net.MrMagicalCart.cartaddon.api.abilities.components.MultiBoxComponent;
import net.MrMagicalCart.cartaddon.cartapi.CartHelper;
import net.MrMagicalCart.cartaddon.entities.LivingPartEntity;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class SeiryuFlyPointAbility
extends MorphAbility2 {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("cartaddon", "textures/abilities/seiryu_fly_point.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("cartaddon", "textures/abilities/alts/seiryu_fly_point.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"seiryu_fly_point", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user transforms into a mythical dragon.", null)});
    public static final AbilityCore<SeiryuFlyPointAbility> INSTANCE;
    private static final AbilityAttributeModifier STRENGTH_MODIFIER;
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_THOUGNESS_MODIFIER;
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE_MODIFIER;
    private static final AbilityAttributeModifier REACH_MODIFIER;
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER;
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final MultiBoxComponent multiBoxComponent = new MultiBoxComponent((IAbility)this);
    private static final float[] SIZEMAP;

    public SeiryuFlyPointAbility(AbilityCore<SeiryuFlyPointAbility> core) {
        super(core);
        super.setDisplayIcon(DEFAULT_ICON);
        if (CartHelper.isApril()) {
            super.setDisplayIcon(ALT_ICON);
        }
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_THOUGNESS_MODIFIER);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.addComponents(new AbilityComponent[]{this.multiBoxComponent});
        this.continuousComponent.addStartEvent(this::onContinuityStart).addTickEvent(this::onTickContinuity).addEndEvent(this::onContinuityEnd);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (CartHelper.isApril()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            PropelledFlightAbility flightAbility;
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
            if (abilityDataProps != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(SeiryuFlightPassiveAbility.INSTANCE)) != null && !flightAbility.isPaused()) {
                PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
            }
            ArrayList<LivingPartEntity> parts = new ArrayList<LivingPartEntity>();
            for (int i = 0; i < 59; ++i) {
                LivingPartEntity partEntity = new LivingPartEntity(entity, EntitySize.func_220314_b((float)(SIZEMAP[i + 1] / 4.0f), (float)10.0f));
                partEntity.func_145769_d(entity.func_145782_y() + i + 1);
                parts.add(partEntity);
            }
            this.multiBoxComponent.setEntities(parts.toArray(new LivingPartEntity[0]));
            this.multiBoxComponent.setDisabled(false);
        }
    }

    private void onTickContinuity(LivingEntity entity, IAbility ability) {
        int i;
        for (LivingPartEntity partEntity : this.multiBoxComponent.getEntities()) {
            partEntity.field_70177_z = 0.0f;
            partEntity.field_70125_A = 0.0f;
        }
        double speed = entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72433_c();
        if (speed > 0.0) {
            for (i = 0; i < this.multiBoxComponent.getEntities().length; ++i) {
                double animPos = Math.toRadians(entity.field_70173_aa) * 3.0;
                this.multiBoxComponent.getEntities()[i].field_70177_z = (float)Math.toDegrees(Math.cos((double)i - animPos) / 3.0);
                if (i <= 0) continue;
                this.multiBoxComponent.getEntities()[i].field_70177_z -= (float)Math.toDegrees(Math.cos((double)(i - 1) - animPos) / 3.0);
            }
        } else {
            for (i = 0; i < 6; ++i) {
                this.multiBoxComponent.getEntities()[i].field_70125_A = -90 + i * 15;
            }
            for (i = 6; i < this.multiBoxComponent.getEntities().length; ++i) {
                this.multiBoxComponent.getEntities()[i].field_70177_z = 25.0f - (float)i / 3.0f + this.multiBoxComponent.getEntities()[i - 1].field_70177_z;
            }
        }
        for (i = 0; i < this.multiBoxComponent.getEntities().length; ++i) {
            LivingPartEntity partEntity = this.multiBoxComponent.getEntities()[i];
            Object prev = i == 0 ? entity : this.multiBoxComponent.getEntities()[i - 1];
            partEntity.field_70177_z += entity.field_70761_aq;
            Vector3d pos = new Vector3d(Math.cos(Math.toRadians(prev.field_70177_z + 90.0f)), Math.cos(Math.toRadians(prev.field_70125_A + 90.0f)), Math.sin(Math.toRadians(prev.field_70177_z + 90.0f))).func_186678_a((double)(-SIZEMAP[i] / 16.0f * 5.0f)).func_178787_e(prev.func_213303_ch());
            partEntity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            partEntity.func_226286_f_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            PropelledFlightAbility flightAbility;
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
            if (abilityDataProps != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(SeiryuFlightPassiveAbility.INSTANCE)) != null) {
                PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
            }
            this.multiBoxComponent.setDisabled(true);
            for (LivingPartEntity partEntity : this.multiBoxComponent.getEntities()) {
                partEntity.func_70106_y();
            }
            this.multiBoxComponent.setEntities(new LivingPartEntity[0]);
        }
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.SEIRYU_FLY.get();
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous()) {
            if (damageSource == DamageSource.field_76379_h) {
                return 0.0f;
            }
            return damage * 0.85f;
        }
        return damage;
    }

    static {
        SIZEMAP = new float[]{0.0f, 18.0f, 18.0f, 26.0f, 39.0f, 26.0f, 40.0f, 39.0f, 27.0f, 37.0f, 28.0f, 39.0f, 37.0f, 27.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 40.0f, 38.253f, 33.747f, 33.0f, 32.0f, 12.0f};
        INSTANCE = new AbilityCore.Builder("Seiryu Fly Point", AbilityCategory.DEVIL_FRUITS, SeiryuFlyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()}).build();
        STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Seiryu Fly Point Strength Modifier", 10.0, AttributeModifier.Operation.ADDITION);
        ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Seiryu Fly Point Attack Speed Modifier", 0.35, AttributeModifier.Operation.ADDITION);
        ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Seiryu Fly Point Armor Modifier", 10.0, AttributeModifier.Operation.ADDITION);
        ARMOR_THOUGNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Seiryu Fly Point Armor Toughness Modifier", 7.0, AttributeModifier.Operation.ADDITION);
        KNOCKBACK_RESISTANCE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Seiryu Fly Point Knockback Resistance Modifier", 5.0, AttributeModifier.Operation.ADDITION);
        REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Seiryu Fly Point Reach Modifier", 4.5, AttributeModifier.Operation.ADDITION);
        TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Seiryu Fly Point Toughness Modifier", 7.0, AttributeModifier.Operation.ADDITION);
    }
}

