/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import net.MrMagicalCart.cartaddon.abilities.uoseriyu.UoSeiryuHelper;
import net.MrMagicalCart.cartaddon.cartapi.CartHelper;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;

public class SeiryuChompAbility
extends Ability {
    private static final ResourceLocation DEFAULT_ICON = new ResourceLocation("cartaddon", "textures/abilities/seiryu_chomp.png");
    private static final ResourceLocation ALT_ICON = new ResourceLocation("cartaddon", "textures/abilities/alts/seiryu_chomp.png");
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"seiryu_chomp", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user chomps down on their opponent, causing them to bleed.", null)});
    private static final int COOLDOWN = 400;
    private static final int HOLD_TIME = 60;
    private static final float RANGE = 4.0f;
    public static final AbilityCore<SeiryuChompAbility> INSTANCE = new AbilityCore.Builder("Seiryu Chomp", AbilityCategory.DEVIL_FRUITS, SeiryuChompAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)7.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)400.0f), RangeComponent.getTooltip((float)4.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent;
    private final GrabEntityComponent grabEntityComponent;
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public SeiryuChompAbility(AbilityCore<SeiryuChompAbility> core) {
        super(core);
        this.setDisplayIcon(DEFAULT_ICON);
        if (CartHelper.isApril()) {
            super.setDisplayIcon(ALT_ICON);
        }
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SEIRYU_FLY.get(), new MorphInfo[0]);
        this.grabEntityComponent = new GrabEntityComponent((IAbility)this, false, true, 5.0f);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.poolComponent, this.dealDamageComponent, this.continuousComponent, this.rangeComponent, this.requireMorphComponent, this.grabEntityComponent});
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addCanUseCheck(UoSeiryuHelper::usingKaenDaiko);
        super.addUseEvent(this::onUseEvent);
        this.addEquipEvent(this::equipEvent);
    }

    public void equipEvent(LivingEntity entity, Ability ability) {
        this.setDisplayIcon(DEFAULT_ICON);
        if (CartHelper.isApril()) {
            this.setDisplayIcon(ALT_ICON);
        }
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            LivingEntity grabbedTarget = this.grabEntityComponent.getGrabbedEntity();
            if (!super.canUse(entity).isFail() && (grabbedTarget == null || this.grabEntityComponent.canContinueGrab(entity))) {
                if (grabbedTarget == null) {
                    this.grabEntityComponent.grabNearest(entity, 4.0f, 1.4f, false);
                }
                if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f) {
                    this.dealDamageComponent.hurtTarget(entity, grabbedTarget, 7.0f);
                }
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            this.grabEntityComponent.release(entity);
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }
}

