/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import net.MrMagicalCart.cartaddon.abilities.uoseriyu.UoSeiryuHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.projectiles.uoseiryu.KaifuProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;

public class KaifuAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kaifu", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires multiple cutting air blades.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<KaifuAbility> INSTANCE = new AbilityCore.Builder("Kaifu", AbilityCategory.DEVIL_FRUITS, KaifuAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceType(new SourceType[]{SourceType.SLASH}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SEIRYU_HEAVY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.SEIRYU_FLY.get(), (MorphInfo)CartMorphs.SEIRYU_HEAVY_PARTIAL.get()});
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.SEIRYU_ABILITY, new AbilityPool2[0]);
    private float cooldown;
    private int triggers;
    private int interval;

    public KaifuAbility(AbilityCore<KaifuAbility> core) {
        super(core);
        this.isNew = true;
        this.cooldown = 400.0f;
        this.triggers = 6;
        this.interval = 10;
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.poolComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < 5; ++i) {
                this.projectileComponent.shootWithSpread(living, 1.5f, 1.0f, 5);
            }
        });
        super.addCanUseCheck(UoSeiryuHelper::usingKaenDaiko);
        super.addCanUseCheck(AbilityLimits::usingBrawler);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        KaifuProjectile projectile = new KaifuProjectile(entity.field_70170_p, entity);
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.SEIRYU_FLY.get()) {
            projectile.setMaxLife(projectile.getLife() * 2);
        }
        return projectile;
    }
}

