/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import java.util.List;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.abilities.uoseriyu.SeiryuFlightPassiveAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.particles.effects.uoseriyu.KaenDaikoParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiEmissionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiInternalDestructionAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiInfusionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.events.FactionEvents;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KaenDaikoAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kaen_daiko", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user imbues themselves with fire, becoming too hot to touch. (Grants \u00a7aFire Resistance\u00a7r).", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    public static final AbilityCore<KaenDaikoAbility> INSTANCE = new AbilityCore.Builder("Kaen Daiko", AbilityCategory.DEVIL_FRUITS, KaenDaikoAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip((float)400.0f), CooldownComponent.getTooltip((float)900.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SEIRYU_FLY.get(), new MorphInfo[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::damageTakenEvent, DamageTakenComponent.DamageState.HURT);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private static final KaenDaikoParticleEffect.Details DETAILS = new KaenDaikoParticleEffect.Details();
    private final Interval particleInterval = new Interval(2);

    public KaenDaikoAbility(AbilityCore<KaenDaikoAbility> core) {
        super(core);
        super.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.damageTakenComponent, this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(this::onContinuityStart).addTickEvent(this::tickContinuityEvent).addEndEvent(this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(SeiryuFlightPassiveAbility.INSTANCE)) != null && !flightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 2, 0, false, false));
        if (!entity.field_70170_p.field_72995_K) {
            if (this.particleInterval.canTick()) {
                DETAILS.setRange(12);
                DETAILS.setSize(8.0f);
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.KAEN_DAIKO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)DETAILS);
            }
            float range = this.rangeComponent.getBonusManager().applyBonus(2.0f);
            List targets = WyHelper.getNearbyEntities((Vector3d)entity.func_213303_ch(), (IWorld)entity.field_70170_p, (double)range, (Predicate)null, (Class[])new Class[]{Entity.class});
            for (Entity target : targets) {
                if (target instanceof LivingEntity) {
                    AbilityHelper.setSecondsOnFireBy((Entity)target, (int)3, (LivingEntity)entity);
                    continue;
                }
                if (!(target instanceof AbilityProjectileEntity)) continue;
                AbilityProjectileEntity abilityProj = (AbilityProjectileEntity)target;
                if (abilityProj.getDamageSource().isPhysical()) {
                    LivingEntity thrower = abilityProj.getThrower();
                    if (thrower == null || thrower == entity) continue;
                    AbilityHelper.setSecondsOnFireBy((Entity)target, (int)3, (LivingEntity)entity);
                    continue;
                }
                target.func_70106_y();
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(SeiryuFlightPassiveAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        Entity sourceEntity;
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous() && (sourceEntity = damageSource.func_76346_g()) != null && sourceEntity instanceof LivingEntity && FactionEvents.isDirectHit((DamageSource)damageSource)) {
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)((LivingEntity)sourceEntity));
            BusoshokuHakiInternalDestructionAbility internal = (BusoshokuHakiInternalDestructionAbility)abilityDataProps.getEquippedAbility(BusoshokuHakiInternalDestructionAbility.INSTANCE);
            HaoshokuHakiInfusionAbility infusion = (HaoshokuHakiInfusionAbility)abilityDataProps.getEquippedAbility(HaoshokuHakiInfusionAbility.INSTANCE);
            BusoshokuHakiEmissionAbility emission = (BusoshokuHakiEmissionAbility)abilityDataProps.getEquippedAbility(BusoshokuHakiEmissionAbility.INSTANCE);
            if (internal != null && internal.isContinuous()) {
                return damage;
            }
            if (infusion != null && infusion.isContinuous()) {
                return damage;
            }
            if (emission != null && emission.isContinuous()) {
                return damage;
            }
            this.dealDamageComponent.hurtTarget(entity, (LivingEntity)sourceEntity, 10.0f);
            sourceEntity.func_70015_d(10);
        }
        return damage;
    }

    public float getContinuityHoldTime() {
        return 400.0f;
    }

    public float getCooldownTicks() {
        return 900.0f;
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.KAEN_DAIKO.get();
    }
}

