/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.uoseriyu;

import net.MrMagicalCart.cartaddon.abilities.uoseriyu.SeiryuHeavyPointAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.uoseiryu.BoloBreathProjectile;
import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BoloBreathAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bolo_breath", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and launches an extremely explosive blast at their opponents.", null)});
    private static final float CHARGE_TIME = 60.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<BoloBreathAbility> INSTANCE = new AbilityCore.Builder("Bolo Breath", AbilityCategory.DEVIL_FRUITS, BoloBreathAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)400.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.SEIRYU_HEAVY.get(), new MorphInfo[]{(MorphInfo)CartMorphs.SEIRYU_FLY.get(), (MorphInfo)CartMorphs.SEIRYU_HEAVY_PARTIAL.get()});
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.SEIRYU_ABILITY, new AbilityPool2[0]);

    public BoloBreathAbility(AbilityCore<BoloBreathAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent, this.requireMorphComponent, this.poolComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        Vector3d look = entity.func_70040_Z().func_72432_b().func_186678_a(2.0);
        if (this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            double height = 0.25;
            IAbilityData prop = AbilityDataCapability.get((LivingEntity)entity);
            SeiryuHeavyPointAbility seiryuHeavyPointAbility = (SeiryuHeavyPointAbility)prop.getEquippedAbility(SeiryuHeavyPointAbility.INSTANCE);
            if (seiryuHeavyPointAbility != null && seiryuHeavyPointAbility.isContinuous()) {
                height = 2.8;
            }
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.OMORI_CHARGING.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 10.0f, 0.25f);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private BoloBreathProjectile createProjectile(LivingEntity entity) {
        BoloBreathProjectile proj = new BoloBreathProjectile(entity.field_70170_p, entity);
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.SEIRYU_FLY.get()) {
            proj.setBlockCollisionSize(8.0);
            proj.setEntityCollisionSize(8.0);
        }
        if (MorphHelper.getZoanInfo((LivingEntity)entity) == CartMorphs.KAEN_DAIKO.get()) {
            proj.setDamage(proj.getDamage() + 10.0f);
        }
        return proj;
    }
}

