/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.twinbarrel;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.mobs.quests.givers.TwinBarrelTrainerEntity;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SpinningBarrelShotsAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"spinning_barrel_shots", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user spins in circles, firing shots.", null)});
    private static final int HOLD_TIME = 60;
    private static final float COOLDOWN = 240.0f;
    private static final float DAMAGE = 7.0f;
    private static final float RANGE = 7.0f;
    private final Interval damageInterval = new Interval(5);
    public static final AbilityCore<SpinningBarrelShotsAbility> INSTANCE = new AbilityCore.Builder("Spinning Barrel Shots", AbilityCategory.STYLE, SpinningBarrelShotsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)7.0f), ContinuousComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)240.0f), RangeComponent.getTooltip((float)7.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET}).setUnlockCheck(SpinningBarrelShotsAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::startContinuousEvent).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public SpinningBarrelShotsAbility(AbilityCore<SpinningBarrelShotsAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent});
        this.addCanUseCheck(AbilityLimits::requiresTwinBarrel);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuousEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof TwinBarrelTrainerEntity) {
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 3));
        }
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        stack = entity.func_184592_cb();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.OFFHAND));
        this.damageInterval.restartIntervalToZero();
        this.animationComponent.start(entity, ModAnimations.BODY_ROTATION_WIDE_ARMS);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        if (!AbilityLimits.canUseTwinBarrel(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.damageInterval.canTick()) {
            List list = this.rangeComponent.getTargetsInArea(entity, 7.0f);
            AbilityDamageSource source = (AbilityDamageSource)((ModDamageSource)this.dealDamageComponent.getDamageSource(entity)).setBlunt();
            for (LivingEntity target : list) {
                this.dealDamageComponent.hurtTarget(entity, target, 7.0f, (DamageSource)source);
            }
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.SPINNING_BARREL_SHOTS.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            if (this.continuousComponent.getContinueTime() % 3.0f == 0.0f) {
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
            }
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.TWIN_BARREL) && questProps.hasFinishedQuest(CartQuests.TWIN_BARREL_TRIAL_02);
    }
}

