/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.twinbarrel;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JumpShotsAbility
extends DropHitAbility {
    private static final int COOLDOWN = 200;
    private static final float RANGE = 6.5f;
    private static final float DAMAGE = 12.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"jump_shots", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user jumps up into the air, and fires shots below.", null)});
    public static final AbilityCore<JumpShotsAbility> INSTANCE = new AbilityCore.Builder("Jump Shots", AbilityCategory.STYLE, JumpShotsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)12.0f), CooldownComponent.getTooltip((float)200.0f), RangeComponent.getTooltip((float)5.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET}).setUnlockCheck(JumpShotsAbility::canUnlock).build();
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private Interval damageTick = new Interval(5);

    public JumpShotsAbility(AbilityCore<JumpShotsAbility> core) {
        super(core);
        this.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.rangeComponent});
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent).addTickEvent(this::tickContinuityEvent).addEndEvent(100, this::endContinuityEvent);
        this.addCanUseCheck(AbilityLimits::requiresTwinBarrel);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)1.0, (double)1.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)1.4, (double)speed.field_72449_c);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.damageTick.canTick()) {
            BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() - 5.0, entity.func_226281_cx_());
            List targets = this.rangeComponent.getTargetsInArea(entity, pos, 5.0f);
            targets.remove(entity);
            AbilityDamageSource source = (AbilityDamageSource)ModDamageSource.causeAbilityDamage((LivingEntity)entity, (AbilityCore)this.getCore()).setBlunt();
            for (LivingEntity target : targets) {
                if (entity.func_70685_l((Entity)target) && !this.dealDamageComponent.hurtTarget(entity, target, 12.0f, (DamageSource)source)) continue;
            }
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.JUMP_SHOTS.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() - 5.0), (double)entity.func_226281_cx_());
            if (this.continuousComponent.getContinueTime() % 4.0f == 0.0f) {
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 1.0f + entity.func_70681_au().nextFloat() / 2.0f);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    public void onLanding(LivingEntity entity) {
    }

    public float getContinueTime(LivingEntity entity) {
        return 60.0f;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.TWIN_BARREL) && questProps.hasFinishedQuest(CartQuests.TWIN_BARREL_TRIAL_03);
    }
}

