/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.twinbarrel;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.items.weapons.ModGunItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DoubleShotsAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"double_shots", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires two shots at a time, consuming bullets. (Bullets are consumed \u00a7a30%%\u00a7r of the time!)", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 120;
    public static final AbilityCore<DoubleShotsAbility> INSTANCE = new AbilityCore.Builder("Double Shots", AbilityCategory.STYLE, DoubleShotsAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)120.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET}).setUnlockCheck(DoubleShotsAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(this::triggerRepeaterEvent).addStopEvent(this::stopRepeaterEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private ItemStack bulletStack = ItemStack.field_190927_a;

    public DoubleShotsAbility(AbilityCore<DoubleShotsAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.continuousComponent, this.repeaterComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityLimits::requiresTwinBarrel);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.repeaterComponent.start(entity, 10, 4);
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        stack = entity.func_184592_cb();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.OFFHAND));
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!AbilityLimits.canUseTwinBarrel(entity)) {
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.bulletStack.func_190926_b()) {
            this.findNewStack(entity);
            if (entity instanceof PlayerEntity && this.bulletStack.func_190926_b()) {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.repeaterComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        double ran;
        float innacuracy = 0.1f;
        if (entity.func_70051_ag()) {
            innacuracy = 0.15f;
        }
        if (entity.func_213453_ef()) {
            innacuracy = 0.0f;
        }
        this.projectileComponent.shoot(entity, 6.0f, innacuracy);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
        this.projectileComponent.shoot(entity, 6.0f, innacuracy);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
        if (entity instanceof PlayerEntity && (ran = Math.random() * 100.0) < 30.0) {
            this.bulletStack.func_190918_g(1);
        }
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
    }

    private AbilityProjectileEntity createProjectile(LivingEntity entity) {
        KairosekiBulletProjectile proj = null;
        if (this.bulletStack.func_77973_b() == ModItems.KAIROSEKI_BULLET.get()) {
            proj = new KairosekiBulletProjectile(entity.field_70170_p, entity);
            proj.setEntityCollisionSize(0.85);
            proj.setDamage(13.0f);
            proj.setMaxLife(80);
        } else {
            proj = new NormalBulletProjectile(entity.field_70170_p, entity);
            proj.setEntityCollisionSize(0.9);
            proj.setDamage(12.0f);
            proj.setMaxLife(75);
        }
        double x = entity.func_226277_ct_() + WyHelper.randomWithRange((int)-1, (int)1) + WyHelper.randomDouble();
        double y = entity.func_226280_cw_() + WyHelper.randomDouble() / 2.0;
        double z = entity.func_226281_cx_() + WyHelper.randomWithRange((int)-1, (int)1) + WyHelper.randomDouble();
        proj.func_70012_b(x, y, z, 0.0f, 0.0f);
        return proj;
    }

    private void findNewStack(LivingEntity entity) {
        List inventory = ItemsHelper.getAllInventoryItems((LivingEntity)entity);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack == null || stack.func_190926_b() || !ModGunItem.GUN_AMMO.test(stack) || stack.func_190916_E() < 4) continue;
            this.bulletStack = stack;
            break;
        }
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.TWIN_BARREL) && questProps.hasFinishedQuest(CartQuests.TWIN_BARREL_TRIAL_04);
    }
}

