/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.twinbarrel;

import java.util.List;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BulletBlastBarrageAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"bullet_blast_barrage", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user lets out a barrage of blasting bullets.", null)});
    private static final float COOLDOWN = 300.0f;
    private static final int CHARGE_TIME = 35;
    private static final float DAMAGE = 14.0f;
    private static final float RANGE = 8.0f;
    private final Interval damageInterval = new Interval(5);
    public static final AbilityCore<BulletBlastBarrageAbility> INSTANCE = new AbilityCore.Builder("Bullet Blast Barrage", AbilityCategory.STYLE, BulletBlastBarrageAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)14.0f), ChargeComponent.getTooltip((float)35.0f), CooldownComponent.getTooltip((float)300.0f), RangeComponent.getTooltip((float)8.0f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET}).setUnlockCheck(BulletBlastBarrageAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);

    public BulletBlastBarrageAbility(AbilityCore<BulletBlastBarrageAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent, this.hitTrackerComponent});
        this.addCanUseCheck(AbilityLimits::requiresTwinBarrel);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 35.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (!AbilityLimits.canUseTwinBarrel(entity)) {
            this.chargeComponent.stopCharging(entity);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        List targets = this.rangeComponent.getTargetsInLine(entity, 8.0f, 4.0f);
        for (LivingEntity target : targets) {
            if (this.hitTrackerComponent.canHit((Entity)target) && this.damageInterval.canTick()) {
                boolean flag = this.dealDamageComponent.hurtTarget(entity, target, 14.0f);
                target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
                if (flag && !entity.field_70170_p.field_72995_K) {
                    int ran = (int)(Math.random() * 100.0 + 1.0);
                    if (ran < 50) {
                        WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)target.func_226280_cw_(), (double)target.func_226281_cx_());
                    } else {
                        WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197601_L, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)target.func_226277_ct_(), (double)target.func_226280_cw_(), (double)target.func_226281_cx_());
                    }
                }
            }
            this.hitTrackerComponent.clearHits();
        }
        if (!entity.field_70170_p.field_72995_K) {
            int range = (int)(Math.random() * 8.0 + 1.0);
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)range);
            double x = mop.func_216347_e().field_72450_a + WyHelper.randomDouble();
            double z = mop.func_216347_e().field_72449_c + WyHelper.randomDouble();
            double y = mop.func_216347_e().field_72448_b + WyHelper.randomDouble();
            int ran = (int)(Math.random() * 100.0 + 1.0);
            if (ran < 50) {
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197601_L, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)x, (double)y, (double)z);
            } else {
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)((ServerWorld)entity.field_70170_p), (double)x, (double)y, (double)z);
            }
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PISTOL_SHOOT.get(), SoundCategory.PLAYERS, 2.0f, 0.5f + entity.func_70681_au().nextFloat() / 4.0f);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.TWIN_BARREL) && questProps.hasFinishedQuest(CartQuests.TWIN_BARREL_TRIAL_01);
    }
}

