/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.twinbarrel;

import java.util.ArrayList;
import java.util.Arrays;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class BackFlipAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"back_flip", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user does a back flip and avoids most attacks briefly.", null)});
    private static final float HOLD_TIME = 20.0f;
    private static final float MIN_COOLDOWN = 80.0f;
    private static final float MAX_COOLDOWN = 300.0f;
    private static final float PROTECTION_TIME = 10.0f;
    public static final AbilityCore<BackFlipAbility> INSTANCE = new AbilityCore.Builder("Back Flip", AbilityCategory.STYLE, BackFlipAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)80.0f, (float)300.0f), ContinuousComponent.getTooltip((float)20.0f)}).setUnlockCheck(BackFlipAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::duringContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final PoolComponent poolComponent;
    private final DamageTakenComponent damageTakenComponent;
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private int hitsTaken = 0;
    private float protTimer = 10.0f;
    private boolean hasFallDamage;

    public BackFlipAbility(AbilityCore<BackFlipAbility> core) {
        super(core);
        this.poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.DODGE_ABILITY, new AbilityPool2[0]);
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this).addOnAttackEvent(this::onDamageTakenEvent);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.continuousComponent, this.poolComponent, this.damageTakenComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(AbilityHelper::requiresFocus);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 20.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, CartAnimations.REVERSE_PITCH_SPIN);
        this.hitsTaken = 0;
        this.protTimer = 0.0f;
        Vector3d speed = entity.func_70040_Z();
        AbilityHelper.setDeltaMovement((Entity)entity, (double)(-speed.field_72450_a), (double)1.05, (double)(-speed.field_72449_c));
        this.hasFallDamage = false;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.protTimer > 0.0f) {
            this.protTimer -= 1.0f;
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float cooldown = 80.0f + this.continuousComponent.getContinueTime() * 5.0f + 5.0f * (float)Math.pow(this.hitsTaken, this.hitsTaken);
        cooldown = Math.min(300.0f, cooldown);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        if (super.isContinuous() && AbilityHelper.canUseMomentumAbilities((LivingEntity)entity) && !AbilityHelper.isGrabbing((LivingEntity)entity)) {
            boolean isDamageTaken = true;
            boolean isUnavoidable = damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isUnavoidable();
            ArrayList<String> acceptableInstantSources = new ArrayList<String>(Arrays.asList("mob", "player", "ability_projectile", "ability"));
            if ((damageSource.func_76364_f() instanceof LivingEntity || damageSource.func_76364_f() instanceof ProjectileEntity) && acceptableInstantSources.contains(damageSource.func_76355_l()) && !isUnavoidable) {
                isDamageTaken = false;
            }
            if (this.protTimer <= 0.0f) {
                if (!isDamageTaken) {
                    SoundEvent sfx = (SoundEvent)ModSounds.DODGE_1.get();
                    if (entity.func_70681_au().nextBoolean()) {
                        sfx = (SoundEvent)ModSounds.DODGE_2.get();
                    }
                    entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), sfx, SoundCategory.PLAYERS, 1.0f, 0.75f + entity.func_70681_au().nextFloat() / 3.0f);
                    ++this.hitsTaken;
                    this.protTimer = 10.0f;
                }
                return isDamageTaken ? damage : 0.0f;
            }
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.getFightingStyle().equals((Object)CartValues.TWIN_BARREL) && questProps.hasFinishedQuest(CartQuests.TWIN_BARREL_TRIAL_05);
    }
}

