/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.toriphoenixextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.particles.effects.toriphoenixextra.NewTenseiNoSoenParticleEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedTenseiNoSoenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"tensei_no_soen", (Pair[])new Pair[]{ImmutablePair.of((Object)"While in the air, the user amasses spiraling flames, then slams into the ground, releasing a massive shockwave.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 600;
    private static final int RANGE = 30;
    private static final int DAMAGE = 50;
    public static final AbilityCore<ReworkedTenseiNoSoenAbility> INSTANCE = new AbilityCore.Builder("Tensei no Soen", AbilityCategory.DEVIL_FRUITS, ReworkedTenseiNoSoenAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)600.0f), ChargeComponent.getTooltip((float)60.0f), RangeComponent.getTooltip((float)30.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip((float)65.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final RequireMorphComponent requireMorphComponent;
    private final ChargeComponent chargeComponent;
    private final ContinuousComponent continuousComponent;
    private final RangeComponent rangeComponent;
    private final DealDamageComponent dealDamageComponent;
    private final HitTrackerComponent hitTrackerComponent;
    private final AnimationComponent animationComponent;
    private final Interval particleInterval = new Interval(10);

    public ReworkedTenseiNoSoenAbility(AbilityCore<ReworkedTenseiNoSoenAbility> core) {
        super(core);
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.PHOENIX_FLY.get(), new MorphInfo[0]);
        this.chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
        this.continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
        this.rangeComponent = new RangeComponent((IAbility)this);
        this.dealDamageComponent = new DealDamageComponent((IAbility)this);
        this.hitTrackerComponent = new HitTrackerComponent((IAbility)this);
        this.animationComponent = new AnimationComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.hitTrackerComponent, this.requireMorphComponent, this.chargeComponent, this.rangeComponent, this.dealDamageComponent, this.continuousComponent});
        this.addCanUseCheck(AbilityHelper::requiresInAir);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.hitTrackerComponent.clearHits();
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.YAW_SPIN);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.TENSEI_NO_SOEN.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_(), (ParticleEffect.Details)new NewTenseiNoSoenParticleEffect.Details(4.0f, 1.5f, 0.5f));
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 30.0f);
        this.animationComponent.stop(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_233570_aj_()) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)-10.0, (double)entity.func_213322_ci().field_72449_c);
            entity.field_70143_R = 0.0f;
        } else if (entity.func_233570_aj_() || DevilFruitHelper.getDifferenceToFloor((Entity)entity) < 2.0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInArea(entity, 30.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0, false, false));
            this.dealDamageComponent.hurtTarget(entity, target, 65.0f);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 60, 0, false, false));
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }
}

