/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.toriphoenixextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HealComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedSaiseiNoHonoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"saisei_no_hono", (Pair[])new Pair[]{ImmutablePair.of((Object)"Uses the blue flames to heal the target by hitting them. Using it while crouching will heal friendly entities around the user at the expense of a longer cooldown based on the number of healed entities.", null)});
    private static final TargetsPredicate TARGETS_CHECK = new TargetsPredicate().testFriendlyFaction();
    private static final float COOLDOWN = 300.0f;
    private static final int RANGE = 12;
    private static final int HEAL = 15;
    public static final AbilityCore<ReworkedSaiseiNoHonoAbility> INSTANCE = new AbilityCore.Builder("Saisei No Hono", AbilityCategory.DEVIL_FRUITS, ReworkedSaiseiNoHonoAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f), ContinuousComponent.getTooltip(), HealComponent.getTooltip((float)15.0f), RangeComponent.getTooltip((float)12.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.PHOENIX_ASSAULT.get(), new MorphInfo[0]);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(200, this::hitEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final HealComponent healComponent = new HealComponent((IAbility)this);
    private int healed;

    public ReworkedSaiseiNoHonoAbility(AbilityCore<ReworkedSaiseiNoHonoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.requireMorphComponent, this.continuousComponent, this.hitTriggerComponent, this.rangeComponent, this.healComponent});
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.healed = 0;
        if (entity.func_213453_ef()) {
            List targets = this.rangeComponent.getTargetsInArea(entity, 12.0f, TARGETS_CHECK);
            int healed = 0;
            for (LivingEntity target : targets) {
                ++healed;
                this.healComponent.healTarget(entity, target, 20.0f);
                target.func_195064_c(new EffectInstance(Effects.field_76428_l, 240, 1));
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.BLUE_FLAMES.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
            }
            this.healed = Math.max(1, healed);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.TENSEI_NO_SOEN_2.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 300.0f + (float)(this.healed * 120));
    }

    private boolean hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            source.setBypassFriendlyDamage();
            this.healComponent.healTarget(entity, target, 20.0f);
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 240, 1));
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.BLUE_FLAMES.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
            this.continuousComponent.stopContinuity(entity);
            return false;
        }
        return true;
    }
}

