/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.toriphoenixextra;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.toriphoenixextra.ReworkedBlueBirdAbility;
import net.MrMagicalCart.cartaddon.abilities.toriphoenixextra.ReworkedPhoenixFlightAbility;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class ReworkedPhoenixAssaultPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"phoenix_assault_point", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a half-phoenix hybrid, which focuses on speed and healing.", null)});
    public static final AbilityCore<ReworkedPhoenixAssaultPointAbility> INSTANCE = new AbilityCore.Builder("Phoenix Assault Point", AbilityCategory.DEVIL_FRUITS, ReworkedPhoenixAssaultPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()}).build();
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private static final AbilityAttributeModifier REGEN_RATE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_REGEN_RATE_UUID, INSTANCE, "Phoenix Assault Point Health Regeneration Speed Modifier", 0.5, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STRENGTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STRENGTH_UUID, INSTANCE, "Phoenix Assault Point Strength Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Phoenix Assault Point Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);

    public ReworkedPhoenixAssaultPointAbility(AbilityCore<ReworkedPhoenixAssaultPointAbility> core) {
        super(core);
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.REGEN_RATE, (AttributeModifier)REGEN_RATE_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)STRENGTH_MODIFIER, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isMorphed);
        this.continuousComponent.addStartEvent(this::onContinuityStart).addTickEvent(100, this::onContinuityTick).addEndEvent(this::onContinuityEnd);
        super.addComponents(new AbilityComponent[]{this.animationComponent});
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(ReworkedPhoenixFlightAbility.INSTANCE)) != null && !flightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        boolean isFlying;
        boolean bl = isFlying = !entity.func_233570_aj_() && DevilFruitHelper.getDifferenceToFloor((Entity)entity) > 1.0;
        if (entity instanceof PlayerEntity) {
            isFlying |= ((PlayerEntity)entity).field_71075_bZ.field_75100_b;
        }
        if (isFlying) {
            if (this.animationComponent.isStopped()) {
                this.animationComponent.start(entity, CartAnimations.PHOENIX_ASSAULT_FLY, -1, e -> {
                    ReworkedBlueBirdAbility blueBird = (ReworkedBlueBirdAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(ReworkedBlueBirdAbility.INSTANCE);
                    return blueBird != null && blueBird.isContinuous();
                });
            }
        } else {
            this.animationComponent.stop(entity);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            PropelledFlightAbility flightAbility;
            this.animationComponent.stop(entity);
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
            if (abilityDataProps != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(ReworkedPhoenixFlightAbility.INSTANCE)) != null) {
                PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
            }
        }
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.PHOENIX_ASSAULT.get();
    }
}

