/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.toriphoenixextra;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedFujiazamiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"fujiazami", (Pair[])new Pair[]{ImmutablePair.of((Object)"While midair, the user forms a protective swirl of fire in front of them capable of blocking most attacks.", null)});
    private static final int HOLD_TIME = 80;
    private static final int MIN_COOLDOWN = 80;
    private static final float MAX_COOLDOWN = 200.0f;
    public static final AbilityCore<ReworkedFujiazamiAbility> INSTANCE = new AbilityCore.Builder("Fujiazami", AbilityCategory.DEVIL_FRUITS, ReworkedFujiazamiAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)80.0f, (float)200.0f), ContinuousComponent.getTooltip((float)80.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.PHOENIX_ASSAULT.get(), new MorphInfo[]{(MorphInfo)CartMorphs.PHOENIX_FLY.get()});
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private Interval particleInterval = new Interval(2);

    public ReworkedFujiazamiAbility(AbilityCore<ReworkedFujiazamiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.requireMorphComponent, this.animationComponent});
        this.addCanUseCheck(AbilityHelper::requiresInAir);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 80.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.particleInterval.restartIntervalToZero();
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 4, 8, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.REDUCED_FALL.get(), 4, 1, false, false));
        boolean flyForm = ((MorphInfo)ModMorphs.PHOENIX_FLY.get()).isActive(entity);
        Vector3d lookVec = entity.func_70040_Z();
        int range = flyForm ? 3 : 2;
        double boxSize = flyForm ? 1.25 : 0.8;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vector3d pos = new Vector3d(entity.func_226277_ct_() + lookVec.field_72450_a * distance, entity.func_226278_cu_() + (double)entity.func_70047_e() + lookVec.field_72448_b * distance, entity.func_226281_cx_() + lookVec.field_72449_c * distance);
            List targets = entity.field_70170_p.func_175674_a((Entity)entity, new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize), targetx -> targetx != entity);
            for (Entity target : targets) {
                if (target instanceof LivingEntity) {
                    Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)3.0, (double)3.0);
                    AbilityHelper.setDeltaMovement((Entity)target, (double)speed.field_72450_a, (double)0.5, (double)speed.field_72449_c);
                    continue;
                }
                if (!(target instanceof AbstractArrowEntity) && !(target instanceof ThrowableEntity)) continue;
                if (target instanceof AbilityProjectileEntity) {
                    float f = ((AbilityProjectileEntity)target).getDamage();
                    int n = flyForm ? 50 : 30;
                    if (f > (float)n) {
                        return;
                    }
                }
                target.func_70106_y();
            }
        }
        if (this.particleInterval.canTick() && this.continuousComponent.getContinueTime() % 5.0f == 0.0f) {
            lookVec.func_216372_d(2.5, 1.0, 2.5);
            Vector3d particlesPos = entity.func_213303_ch().func_178787_e(lookVec);
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.FUJIZAMI.get()), (Entity)entity, (double)particlesPos.field_72450_a, (double)(entity.func_226278_cu_() + (double)(entity.func_70047_e() / 2.0f)), (double)particlesPos.field_72449_c);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float cooldown = 80.0f + this.continuousComponent.getContinueTime() * 1.5f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

