/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.toriphoenixextra;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.text.DecimalFormat;
import net.MrMagicalCart.cartaddon.abilities.toriphoenixextra.ReworkedPhoenixFlyPointAbility;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ConsumptionComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdatePassiveAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ReworkedFlamesOfRegenerationAbility
extends PassiveAbility2 {
    private static final int MAX_ENERGY = 100;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"phoenix_fly_point", (Pair[])new Pair[]{ImmutablePair.of((Object)"Protects the user and heals them back up when damage is taken, has an initial reserve of \u00a7a%s Energy\u00a7r which increases with time and decreses with each heal.", (Object)new Object[]{100})});
    public static final AbilityCore<ReworkedFlamesOfRegenerationAbility> INSTANCE = new AbilityCore.Builder("Flames of Regeneration", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, ReworkedFlamesOfRegenerationAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this).addOnAttackEvent(this::onDamageTaken);
    private final ConsumptionComponent consumptionComponent = new ConsumptionComponent((IAbility)this).addConsumptionEvent(this::onConsumption);
    private static final int MAX_COOLDOWN = 100;
    private double energy = 100.0;
    private int cooldown = 0;
    private int invulnerableTime = 0;
    private Interval recuperationInterval = new Interval(10);
    private Interval regenerationInterval = new Interval(40);

    public ReworkedFlamesOfRegenerationAbility(AbilityCore<ReworkedFlamesOfRegenerationAbility> ability) {
        super(ability);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent((IAbility)this, this::renderGauge);
            super.addComponents(new AbilityComponent[]{gaugeComponent});
        }
        super.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.consumptionComponent});
        super.addDuringPassiveEvent(this::duringPassive);
    }

    private void duringPassive(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            --this.invulnerableTime;
            if (this.regenerationInterval.canTick() && this.energy - 4.0 >= 0.0 && entity.func_110143_aJ() < entity.func_110138_aP()) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.FLAMES_OF_REGEN.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
                entity.func_70691_i(2.0f);
                this.addEnergy(entity, -5.0);
            }
            if (!WyHelper.isInCombat((LivingEntity)entity)) {
                if (entity.func_70608_bn() && this.recuperationInterval.canTick()) {
                    this.addEnergy(entity, 10.0);
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                } else {
                    if (this.cooldown <= 0 && this.energy <= 0.0) {
                        this.addEnergy(entity, 1.0);
                    }
                    if (this.energy <= 0.0) {
                        this.cooldown = 100;
                    } else {
                        this.addEnergy(entity, 0.05);
                    }
                }
            }
        }
    }

    public float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        if (super.isPaused()) {
            return damage;
        }
        if (this.invulnerableTime > 0) {
            return 0.0f;
        }
        boolean hasShadow = EntityStatsCapability.get((LivingEntity)entity).hasShadow();
        if (!(source instanceof ModDamageSource && ((ModDamageSource)source).isBypassingLogia() || source.func_76347_k() && !hasShadow)) {
            if (DevilFruitCapability.get((LivingEntity)entity).hasYamiPower()) {
                return damage;
            }
            boolean isImmune = true;
            if (source.func_76364_f() != null) {
                boolean hasHardeningActive;
                Entity projectileOwner;
                LivingEntity sourceOwner = null;
                if (source.func_76364_f() instanceof LivingEntity) {
                    sourceOwner = (LivingEntity)source.func_76364_f();
                } else if (source.func_76364_f() instanceof AbilityProjectileEntity) {
                    sourceOwner = ((AbilityProjectileEntity)source.func_76364_f()).getThrower();
                } else if (source.func_76364_f() instanceof ProjectileEntity && (projectileOwner = ((ProjectileEntity)source.func_76364_f()).func_234616_v_()) != null && projectileOwner instanceof LivingEntity) {
                    sourceOwner = (LivingEntity)projectileOwner;
                    hasHardeningActive = HakiHelper.hasImbuingActive((LivingEntity)((LivingEntity)projectileOwner));
                    isImmune &= !hasHardeningActive;
                }
                if (sourceOwner != null) {
                    boolean hasImbuingActive = HakiHelper.hasImbuingActive((LivingEntity)sourceOwner);
                    hasHardeningActive = HakiHelper.hasHardeningActive((LivingEntity)sourceOwner);
                    if (source instanceof ModDamageSource) {
                        ModDamageSource mSource = (ModDamageSource)source;
                        if (mSource.getHakiNature() == SourceHakiNature.IMBUING && hasImbuingActive) {
                            isImmune = false;
                        } else if (mSource.getHakiNature() == SourceHakiNature.HARDENING && hasHardeningActive) {
                            isImmune = false;
                        } else if (mSource.getHakiNature() == SourceHakiNature.SPECIAL && (hasImbuingActive || hasHardeningActive)) {
                            isImmune = false;
                        }
                    } else if (source instanceof EntityDamageSource) {
                        isImmune &= !hasHardeningActive;
                    } else if (source instanceof IndirectEntityDamageSource) {
                        isImmune &= !hasImbuingActive;
                    }
                }
            }
            if (isImmune && this.energy - (double)damage >= 0.0) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.FLAMES_OF_REGEN.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
                this.addEnergy(entity, -damage);
                this.invulnerableTime = 10;
                return 0.0f;
            }
            this.cooldown = 100;
            return damage;
        }
        return damage;
    }

    private boolean onConsumption(LivingEntity entity, IAbility ability, int nutrition, float saturationModifier) {
        this.addEnergy(entity, (double)((float)nutrition * saturationModifier) * 2.0);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, ReworkedFlamesOfRegenerationAbility ability) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        RendererHelper.drawAbilityIcon(ReworkedPhoenixFlyPointAbility.INSTANCE, (MatrixStack)matrixStack, (float)posX, (float)(posY - 38), (int)0, (float)32.0f, (float)32.0f);
        DecimalFormat energyFormat = new DecimalFormat("#0.0");
        String energy = energyFormat.format(ability.energy);
        WyHelper.drawStringWithBorder((FontRenderer)mc.field_71466_p, (MatrixStack)matrixStack, (String)energy, (int)(posX + 15 - mc.field_71466_p.func_78256_a(energy) / 2), (int)(posY - 25), (int)Color.WHITE.getRGB());
    }

    public void addEnergy(LivingEntity entity, double energy) {
        this.energy = MathHelper.func_151237_a((double)(this.energy + energy), (double)0.0, (double)100.0);
        if (entity instanceof PlayerEntity) {
            WyNetwork.sendTo((Object)new SUpdatePassiveAbilityDataPacket(entity, (IAbility)this), (PlayerEntity)((PlayerEntity)entity));
        }
    }

    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74780_a("energy", this.energy);
        return nbt;
    }

    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.energy = nbt.func_74769_h("energy");
    }
}

