/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.torifalcon;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class TobizumeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"tobizume", (Pair[])new Pair[]{ImmutablePair.of((Object)"While in the air, the user spins and then slams into the ground, releasing a shockwave.", null)});
    private static final int CHARGE_TIME = 60;
    private static final int COOLDOWN = 600;
    private static final int RANGE = 30;
    private static final int DAMAGE = 50;
    public static final AbilityCore<TobizumeAbility> INSTANCE = new AbilityCore.Builder("Tobizume", AbilityCategory.DEVIL_FRUITS, TobizumeAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)50.0f), ChargeComponent.getTooltip((float)30.0f), CooldownComponent.getTooltip((float)600.0f), RangeComponent.getTooltip((float)20.0f, (RangeComponent.RangeType)RangeComponent.RangeType.AOE)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{RequireMorphComponent.getTooltip()}).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.FALCON_FLY.get(), new MorphInfo[0]);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);

    public TobizumeAbility(AbilityCore<TobizumeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.animationComponent, this.hitTrackerComponent, this.requireMorphComponent, this.chargeComponent, this.rangeComponent, this.dealDamageComponent, this.continuousComponent});
        this.addCanUseCheck(AbilityHelper::requiresInAir);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            this.hitTrackerComponent.clearHits();
            this.chargeComponent.startCharging(entity, 30.0f);
        }
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.YAW_SPIN);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 30.0f);
        this.animationComponent.stop(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!entity.func_233570_aj_()) {
            AbilityHelper.setDeltaMovement((Entity)entity, (double)entity.func_213322_ci().field_72450_a, (double)-10.0, (double)entity.func_213322_ci().field_72449_c);
            entity.field_70143_R = 0.0f;
        } else if (entity.func_233570_aj_() || DevilFruitHelper.getDifferenceToFloor((Entity)entity) < 2.0) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        List targets = this.rangeComponent.getTargetsInArea(entity, 20.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 10, 0, false, false));
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 10, 0, false, false));
            this.dealDamageComponent.hurtTarget(entity, target, 50.0f);
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 40, 0, false, false));
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }
}

