/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.torifalcon;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.torifalcon.FalconFlightAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class FalconFlyPointAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"falcon_fly_point", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a falcon, which focuses on speed.", null)});
    public static final AbilityCore<FalconFlyPointAbility> INSTANCE = new AbilityCore.Builder("Falcon Fly Point", AbilityCategory.DEVIL_FRUITS, FalconFlyPointAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier ARMOR = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Falcon Fly Point Armor Modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier FALL_DAMAGE = new AbilityAttributeModifier(AttributeHelper.MORPH_FALL_RESISTANCE_UUID, INSTANCE, "Falcon Fly Point Fall Damage Modifier", 500.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Falcon Fly Point Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Falcon Fly Point Armor Toughness Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier PUNCH_DMG = new AbilityAttributeModifier(AttributeHelper.ATTACK_DAMAGE_MODIFIER, INSTANCE, "Falcon Fly Point Punch Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier REACH = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Falcon Fly Point Reach Modifier", 2.0, AttributeModifier.Operation.ADDITION);

    public FalconFlyPointAbility(AbilityCore<FalconFlyPointAbility> core) {
        super(core);
        Predicate<LivingEntity> isMorphed = entity -> this.morphComponent.isMorphed();
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_DAMAGE, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS, isMorphed);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)PUNCH_DMG, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH, isMorphed);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH, isMorphed);
        this.continuousComponent.addStartEvent(this::onContinuityStart).addEndEvent(this::onContinuityEnd);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(FalconFlightAbility.INSTANCE)) != null && !flightAbility.isPaused()) {
            PropelledFlightAbility.enableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        PropelledFlightAbility flightAbility;
        IAbilityData abilityDataProps;
        if (!entity.field_70170_p.field_72995_K && (abilityDataProps = AbilityDataCapability.get((LivingEntity)entity)) != null && (flightAbility = (PropelledFlightAbility)abilityDataProps.getPassiveAbility(FalconFlightAbility.INSTANCE)) != null) {
            PropelledFlightAbility.disableFlight((PlayerEntity)((PlayerEntity)entity));
        }
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.FALCON_FLY.get();
    }
}

