/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.torifalcon;

import net.MrMagicalCart.cartaddon.abilities.torifalcon.AirCutterAbility;
import net.MrMagicalCart.cartaddon.abilities.torifalcon.FalconAssaultPointAbility;
import net.MrMagicalCart.cartaddon.abilities.torifalcon.FalconFlyPointAbility;
import net.MrMagicalCart.cartaddon.abilities.torifalcon.TalonCarryAbility;
import net.MrMagicalCart.cartaddon.abilities.torifalcon.TobizumeAbility;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.api.IPlayerAbilities;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class FalconFlightAbility
extends PropelledFlightAbility {
    public static final AbilityCore<FalconFlightAbility> INSTANCE = new AbilityCore.Builder("Falcon Flight", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, FalconFlightAbility::new).build();

    public FalconFlightAbility(AbilityCore<FalconFlightAbility> core) {
        super(core);
        super.addCanUseCheck(this::canFly);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    private void onDuringPassive(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            boolean isFlightActive;
            PlayerEntity player = (PlayerEntity)entity;
            IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
            FalconFlyPointAbility flyPointAbility = (FalconFlyPointAbility)abilityDataProps.getEquippedAbility(FalconFlyPointAbility.INSTANCE);
            double difference = DevilFruitHelper.getDifferenceToFloor((Entity)player);
            boolean bl = isFlightActive = flyPointAbility != null && flyPointAbility.isContinuous();
            if (isFlightActive) {
                if (((IPlayerAbilities)player.field_71075_bZ).hasCustomFlight() && !player.field_71075_bZ.field_75100_b) {
                    player.field_71075_bZ.field_75100_b = true;
                }
                if (difference < 2.0) {
                    AbilityHelper.setDeltaMovement((Entity)player, (Vector3d)player.func_213322_ci().func_72441_c(0.0, 1.0, 0.0).func_216372_d(1.0, 0.25, 1.0));
                }
            }
        }
    }

    public float getMaxSpeed(LivingEntity entity) {
        float maxSpeed = 0.0f;
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        FalconAssaultPointAbility assaultPointAbility = (FalconAssaultPointAbility)abilityDataProps.getEquippedAbility(FalconAssaultPointAbility.INSTANCE);
        FalconFlyPointAbility flyPointAbility = (FalconFlyPointAbility)abilityDataProps.getEquippedAbility(FalconFlyPointAbility.INSTANCE);
        if (assaultPointAbility != null && assaultPointAbility.isContinuous()) {
            maxSpeed = entity.func_70051_ag() ? 0.85f : 0.425f;
        } else if (flyPointAbility != null && flyPointAbility.isContinuous()) {
            maxSpeed = entity.func_70051_ag() ? 0.9f : 0.4f;
        }
        EffectInstance fatigueEffectInstance = entity.func_70660_b((Effect)ModEffects.FATIGUE_EFFECT.get());
        if (fatigueEffectInstance != null) {
            maxSpeed /= 1.0f + Math.min((float)fatigueEffectInstance.func_76458_c(), 3.0f);
        }
        return maxSpeed;
    }

    protected float getAcceleration(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        FalconAssaultPointAbility assaultPointAbility = (FalconAssaultPointAbility)abilityDataProps.getEquippedAbility(FalconAssaultPointAbility.INSTANCE);
        FalconFlyPointAbility flyPointAbility = (FalconFlyPointAbility)abilityDataProps.getEquippedAbility(FalconFlyPointAbility.INSTANCE);
        if (assaultPointAbility != null && assaultPointAbility.isContinuous()) {
            return entity.func_70051_ag() ? 0.005f : 0.0025f;
        }
        if (flyPointAbility != null && flyPointAbility.isContinuous()) {
            return entity.func_70051_ag() ? 0.007f : 0.0035f;
        }
        return 0.0f;
    }

    protected int getHeightDifference(LivingEntity entity) {
        return 50;
    }

    public float getSpeed(LivingEntity entity) {
        AirCutterAbility airCutterAbility = (AirCutterAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(AirCutterAbility.INSTANCE);
        TalonCarryAbility talonCarryAbility = (TalonCarryAbility)AbilityDataCapability.get((LivingEntity)entity).getEquippedAbility(TalonCarryAbility.INSTANCE);
        if (airCutterAbility != null && ((ContinuousComponent)airCutterAbility.getComponent(ModAbilityKeys.CONTINUOUS).get()).isContinuous()) {
            entity.field_191988_bg = 0.7f;
            return this.speed += 1.0f;
        }
        if (talonCarryAbility != null && ((ContinuousComponent)talonCarryAbility.getComponent(ModAbilityKeys.CONTINUOUS).get()).isContinuous()) {
            entity.field_191988_bg = 0.7f;
            return this.speed += 1.0f;
        }
        return this.speed;
    }

    private AbilityUseResult canFly(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        FalconAssaultPointAbility assaultPointAbility = (FalconAssaultPointAbility)abilityDataProps.getEquippedAbility(FalconAssaultPointAbility.INSTANCE);
        FalconFlyPointAbility flyPointAbility = (FalconFlyPointAbility)abilityDataProps.getEquippedAbility(FalconFlyPointAbility.INSTANCE);
        TobizumeAbility tobizumeAbility = (TobizumeAbility)abilityDataProps.getEquippedAbility(TobizumeAbility.INSTANCE);
        boolean isTobizumeActive = tobizumeAbility != null && tobizumeAbility.isContinuous();
        return !(assaultPointAbility != null && assaultPointAbility.isContinuous() || flyPointAbility != null && flyPointAbility.isContinuous() && !isTobizumeActive) ? AbilityUseResult.fail(null) : AbilityUseResult.success();
    }
}

