/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.swordsmenextra;

import java.awt.Color;
import net.MrMagicalCart.cartaddon.abilities.modifiedhuman.ModifiedHumanHelper;
import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.MrMagicalCart.cartaddon.entities.mobs.marines.SHawkEntity;
import net.MrMagicalCart.cartaddon.entities.projectiles.swordsmenextra.VoidShatteringSlashProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.LightningDischargeEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class VoidShatteringSlashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"void_shattering_slash", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user launches a crescent moon-shaped slash, which slices the void itself. (Fruitless)", null)});
    private static final float COOLDOWN = 1200.0f;
    public static final AbilityCore<VoidShatteringSlashAbility> INSTANCE;
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::startChargeEvent).addTickEvent(this::tickChargeEvent).addEndEvent(this::endChargeEvent);
    public static int overuse;
    private LightningDischargeEntity discharge;
    private Color color = new Color(0xFF0000);
    private int radius = 0;
    private int haoMastery = 0;
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public VoidShatteringSlashAbility(AbilityCore<VoidShatteringSlashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.poolComponent, this.chargeComponent, this.animationComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        super.addCanUseCheck(ModifiedHumanHelper::checkModifiedHuamn);
        this.addCanUseCheck(AbilityLimits::fruitless);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse;
        if (!HakiHelper.hasInfusionActive((LivingEntity)entity)) {
            entity.func_145747_a((ITextComponent)new StringTextComponent("You need to activate Hao Infusion to use this move!"), entity.func_110124_au());
            return;
        }
        if (!WyHelper.isInChallengeDimension((World)entity.field_70170_p) && (isOnMaxOveruse = HakiHelper.checkForHakiOveruse((LivingEntity)entity, (int)overuse))) {
            return;
        }
        if (entity instanceof SHawkEntity) {
            this.color = new Color(56089);
        }
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM);
        } else if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, ModAnimations.RAISE_LEFT_ARM);
        }
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)entity);
        float haoLevel = hakiProps.getTotalHakiExp() / 100.0f;
        if (haoLevel <= 1.0f) {
            this.radius = 10;
            this.haoMastery = 0;
        } else if (haoLevel > 1.0f && haoLevel <= 1.75f) {
            this.radius = 25;
            this.haoMastery = 1;
        } else if (haoLevel > 1.75f) {
            this.radius = 40;
            this.haoMastery = 2;
        }
        if (entity instanceof PlayerEntity) {
            this.color = new Color(HakiHelper.getHaoshokuColour((LivingEntity)entity));
        }
        this.discharge = new LightningDischargeEntity((Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_() + 1.5, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        this.discharge.setAliveTicks(-1);
        this.discharge.setUpdateRate(8);
        this.discharge.setLightningLength((float)(this.radius * 2));
        this.discharge.setColor(new Color(0, 0, 0, 100));
        this.discharge.setOutlineColor(this.color);
        this.discharge.setRenderTransparent();
        this.discharge.setDetails(16);
        int density = this.haoMastery == 2 ? 32 : 16;
        this.discharge.setDensity(density);
        this.discharge.setSize(1.0f);
        this.discharge.setSkipSegments(1);
        if (this.haoMastery == 0) {
            this.discharge.setSplit();
        }
        if (entity instanceof PlayerEntity) {
            entity.field_70170_p.func_217376_c((Entity)this.discharge);
            if (this.discharge != null) {
                this.discharge.setAliveTicks(40);
            }
        }
    }

    private void tickChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 2, 2, false, false));
        if (this.chargeComponent.getChargeTime() % 5.0f == 0.0f) {
            this.discharge.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 1.0, entity.func_226281_cx_());
        }
        if (this.chargeComponent.getChargeTime() % 10.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.HAKI_RELEASE_SFX.get(), SoundCategory.PLAYERS, 3.0f, 0.5f + entity.func_70681_au().nextFloat());
        }
        if (this.discharge != null && !entity.func_70089_S()) {
            this.discharge.setAliveTicks(0);
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        ItemStack stack = entity.func_184614_ca();
        stack.func_222118_a(1, entity, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        this.animationComponent.stop(entity);
        this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        if (this.discharge != null) {
            this.discharge.setAliveTicks(30);
        }
        this.cooldownComponent.startCooldown(entity, 1200.0f);
    }

    private VoidShatteringSlashProjectile createProjectile(LivingEntity entity) {
        VoidShatteringSlashProjectile proj = new VoidShatteringSlashProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isSwordsman() && questProps.hasFinishedQuest(CartQuests.SWORDSMAN_TRIAL_07);
    }

    static {
        overuse = 750;
        INSTANCE = new AbilityCore.Builder("Void Shattering Slash", AbilityCategory.STYLE, VoidShatteringSlashAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)40.0f), CooldownComponent.getTooltip((float)1200.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).setSourceElement(SourceElement.AIR).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setUnlockCheck(VoidShatteringSlashAbility::canUnlock).build();
    }
}

