/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.swordsmenextra;

import net.MrMagicalCart.cartaddon.init.CartAbilityPools;
import net.MrMagicalCart.cartaddon.init.CartAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.OTatsumakiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class SteelResolveAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"steel_resolve", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user reduces 70% damage from the next three high damaging hits.", null)});
    private static final float HOLD_TIME = 100.0f;
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<SteelResolveAbility> INSTANCE = new AbilityCore.Builder("Steel Resolve", AbilityCategory.STYLE, SteelResolveAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)100.0f), CooldownComponent.getTooltip((float)400.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::onTickContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final PoolComponent poolComponent;
    private final DamageTakenComponent damageTakenComponent;
    private final StackComponent stackComponent = new StackComponent((IAbility)this, 3);

    public SteelResolveAbility(AbilityCore<SteelResolveAbility> core) {
        super(core);
        this.poolComponent = new PoolComponent((IAbility)this, CartAbilityPools.PARRY_COUNTER, new AbilityPool2[]{ModAbilityPools.GRAB_ABILITY});
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTakenEvent, DamageTakenComponent.DamageState.ATTACK);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.stackComponent, this.continuousComponent, this.animationComponent, this.poolComponent, this.damageTakenComponent});
        this.addCanUseCheck(AbilityHelper::canUseSwordsmanAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 100.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            this.animationComponent.start(entity, CartAnimations.STEEL_RESOLVE_RIGHT);
        } else if (entity.func_184591_cq() == HandSide.LEFT) {
            this.animationComponent.start(entity, CartAnimations.STEEL_RESOLVE_LEFT);
        }
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData abilityProps;
        OTatsumakiAbility oTatsumakiAbility;
        boolean active;
        if (this.stackComponent.getStacks() <= 0) {
            this.continuousComponent.stopContinuity(entity);
        }
        boolean bl = active = (oTatsumakiAbility = (OTatsumakiAbility)(abilityProps = AbilityDataCapability.get((LivingEntity)entity)).getEquippedAbility(OTatsumakiAbility.INSTANCE)) != null && oTatsumakiAbility.isContinuous();
        if (active) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 2, false, false));
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.revertStacksToDefault(entity, (IAbility)this);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (!this.continuousComponent.isContinuous()) {
            return damage;
        }
        Entity sourceEntity = source.func_76346_g();
        if (sourceEntity == null) {
            return damage;
        }
        if (this.stackComponent.getStacks() > 0) {
            this.stackComponent.addStacks(entity, (IAbility)this, -1);
            if (damage > 10.0f) {
                entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GUARD.get(), SoundCategory.PLAYERS, 3.0f, 2.0f + entity.func_70681_au().nextFloat() / 3.0f);
                return damage * 0.3f;
            }
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.GUARD.get(), SoundCategory.PLAYERS, 3.0f, 0.75f);
            return damage;
        }
        return damage;
    }
}

