/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.susu;

import net.MrMagicalCart.cartaddon.init.CartEffects;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KarasusuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"karasusu", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user turns into a massive clouds of soot carrying targets and suffocating them.", null)});
    private static final int COOLDOWN = 320;
    private static final int HOLD_TIME = 60;
    private static final float DAMAGE = 10.0f;
    public static final AbilityCore<KarasusuAbility> INSTANCE = new AbilityCore.Builder("Karasusu", AbilityCategory.DEVIL_FRUITS, KarasusuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)320.0f), ContinuousComponent.getTooltip((float)60.0f), DealDamageComponent.getTooltip((float)10.0f)}).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuityComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private Interval particleInterval = new Interval(5);

    public KarasusuAbility(AbilityCore<KarasusuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuityComponent, this.hitTrackerComponent, this.dealDamageComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.triggerContinuity(entity, 60.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)3.0, (double)3.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)2.0, (double)speed.field_72449_c);
        this.particleInterval.restartIntervalToZero();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!(this.continuityComponent.getContinueTime() < 3.0f)) {
            Vector3d speed = entity.func_70040_Z().func_216372_d(1.2, 1.2, 1.2);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)speed.field_72448_b, (double)speed.field_72449_c);
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 15, 0, false, false));
            if (this.particleInterval.canTick()) {
                WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.KARASUSU.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
            }
            float growthXZ = 8.0f;
            float growthY = 20.0f;
            AxisAlignedBB box = new AxisAlignedBB(new BlockPos(entity.func_213303_ch())).func_72314_b((double)growthXZ, (double)growthY, (double)growthXZ);
            for (Entity target : entity.field_70170_p.func_175647_a(Entity.class, box, e -> e != entity)) {
                AbilityHelper.setDeltaMovement((Entity)target, (double)(target.func_213322_ci().field_72450_a + (entity.func_226277_ct_() - target.func_226277_ct_()) / 20.0), (double)(target.func_213322_ci().field_72448_b + (entity.func_226278_cu_() - target.func_226278_cu_()) / 20.0), (double)(target.func_213322_ci().field_72449_c + (entity.func_226281_cx_() - target.func_226281_cx_()) / 20.0));
                ModDamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this, (String)"flyIntoWall").setPiercing(1.0f);
                if (!this.hitTrackerComponent.canHit(target) || !(target instanceof LivingEntity) || !(entity.func_70032_d(target) < 2.0f)) continue;
                this.dealDamageComponent.hurtTarget(entity, (LivingEntity)target, 10.0f, (DamageSource)source);
                entity.func_195064_c(new EffectInstance((Effect)CartEffects.SOOT.get(), 100, 0, false, false));
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 320.0f);
    }
}

