/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sunaextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.sunaextra.ReworkedSablesPesadoProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedSablesPesadoAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"sables_pesado", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user compresses a sandstorm to its limits and shoots it at extreme speeds.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(50.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 800;
    private static final int CHARGE_TIME = 140;
    public static final AbilityCore<ReworkedSablesPesadoAbility> INSTANCE = new AbilityCore.Builder("Sables: Pesado Reworked", AbilityCategory.DEVIL_FRUITS, ReworkedSablesPesadoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)70.0f, (float)140.0f), CooldownComponent.getTooltip((float)400.0f, (float)800.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> comp.getChargePercentage() >= 0.5f).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private Interval particleInterval = new Interval(5);

    public ReworkedSablesPesadoAbility(AbilityCore<ReworkedSablesPesadoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.chargeComponent, this.projectileComponent});
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.particleInterval.restartIntervalToZero();
            this.chargeComponent.startCharging(entity, 140.0f);
        } else if (this.chargeComponent.isCharging() && this.chargeComponent.getChargeTime() >= 70.0f) {
            this.chargeComponent.stopCharging(entity);
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.REDUCED_FALL.get(), 2, 1, false, false));
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.SABLES_PESADO.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        float multiplier;
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.SABLES_PESADO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        ReworkedSablesPesadoProjectile projectile = new ReworkedSablesPesadoProjectile(entity.field_70170_p, entity);
        projectile.multiplier = multiplier = this.chargeComponent.getChargePercentage();
        projectile.setSize((double)multiplier > 0.75 ? 0.6f : 5.0f * (1.0f - multiplier));
        projectile.setChargedAmount(this.chargeComponent.getChargePercentage());
        entity.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 3.25f, 0.0f);
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted((LivingEntity)entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 800.0f * this.chargeComponent.getChargePercentage());
    }

    private ReworkedSablesPesadoProjectile createProjectile(LivingEntity entity) {
        ReworkedSablesPesadoProjectile proj = new ReworkedSablesPesadoProjectile(entity.field_70170_p, entity);
        return proj;
    }
}

