/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sunaextra;

import net.MrMagicalCart.cartaddon.entities.projectiles.sunaextra.ReworkedDesertGrandeEspadaProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedDesertGrandeEspadaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float DAMAGE_BONUS = 1.15f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"desert_grande_espada", (Pair[])new Pair[]{ImmutablePair.of((Object)"Spawns a large sand blade cutting through multiple enemies wherever the user is looking.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.14999998f) * 100.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 400;
    private static final int CHARGE_TIME = 10;
    public static final AbilityCore<ReworkedDesertGrandeEspadaAbility> INSTANCE = new AbilityCore.Builder("Desert Grande Espada Reworked", AbilityCategory.DEVIL_FRUITS, ReworkedDesertGrandeEspadaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)400.0f), ChargeComponent.getTooltip((float)10.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.SLASH}).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private Vector3d targetPos;

    public ReworkedDesertGrandeEspadaAbility(AbilityCore<ReworkedDesertGrandeEspadaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.chargeComponent});
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 10.0f);
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (this.targetPos == null) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, (double)64.0);
            double i = mop.func_216347_e().field_72450_a;
            double k = mop.func_216347_e().field_72449_c;
            int y = entity.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, (int)i, (int)k);
            this.targetPos = new Vector3d(i, (double)y, k);
        }
        if (!entity.field_70170_p.field_72995_K) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.SAND_BLADE_IDLE.get()), (Entity)entity, (double)this.targetPos.field_72450_a, (double)this.targetPos.field_72448_b, (double)this.targetPos.field_72449_c);
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 1, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            ReworkedDesertGrandeEspadaProjectile pillar = (ReworkedDesertGrandeEspadaProjectile)this.projectileComponent.getNewProjectile(entity);
            pillar.func_70012_b(this.targetPos.field_72450_a, this.targetPos.field_72448_b - 6.0, this.targetPos.field_72449_c, 0.0f, 0.0f);
            pillar.func_70186_c(0.0, 0.7, 0.0, 1.4f, 0.0f);
            entity.field_70170_p.func_217376_c((Entity)pillar);
        }
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted((LivingEntity)entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
        this.targetPos = null;
    }

    private ReworkedDesertGrandeEspadaProjectile createProjectile(LivingEntity entity) {
        boolean fruitBoosted = SunaHelper.isFruitBoosted((LivingEntity)entity);
        this.projectileComponent.getDamageBonusManager().removeBonus(SunaHelper.DESERT_DAMAGE_BONUS);
        if (fruitBoosted) {
            this.projectileComponent.getDamageBonusManager().addBonus(SunaHelper.DESERT_DAMAGE_BONUS, "Desert Damage Bonus", BonusOperation.MUL, 1.15f);
        }
        ReworkedDesertGrandeEspadaProjectile proj = new ReworkedDesertGrandeEspadaProjectile(entity.field_70170_p, entity);
        return proj;
    }

    public void setTargetPos(Vector3d vec) {
        this.targetPos = vec;
    }
}

