/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sunaextra;

import net.MrMagicalCart.cartaddon.api.helpers.AbilityLimits;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedDesertEncierroAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"desert_encierro", (Pair[])new Pair[]{ImmutablePair.of((Object)"Quickly drains the enemy in front of the user of their moisture, leaving them weak for a few seconds.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 300;
    private static final int CHARGE_TIME = 50;
    private static final int PULL_TIME = 200;
    private static final float DAMAGE = 20.0f;
    public static final AbilityCore<ReworkedDesertEncierroAbility> INSTANCE = new AbilityCore.Builder("Desert Encierro Reworked", AbilityCategory.DEVIL_FRUITS, ReworkedDesertEncierroAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)300.0f), ChargeComponent.getTooltip((float)50.0f), DealDamageComponent.getTooltip((float)20.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final GrabEntityComponent grabComponent = new GrabEntityComponent((IAbility)this, true, true, true, 2.0f).addPullStartEvent(this::onPullStart).addPullEndEvent(this::onPullEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent((IAbility)this).addOnHitEvent(this::onHitEvent);
    private final PoolComponent poolComponent = new PoolComponent((IAbility)this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);
    private final Interval particleInterval = new Interval(6);

    public ReworkedDesertEncierroAbility(AbilityCore<ReworkedDesertEncierroAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.dealDamageComponent, this.chargeComponent, this.animationComponent, this.continuousComponent, this.grabComponent, this.hitTriggerComponent, this.poolComponent});
        super.addCanUseCheck(AbilityHelper::canUseBrawlerAbilities);
        super.addCanUseCheck(AbilityHelper::requiresDryUser);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            if (this.continuousComponent.isContinuous()) {
                this.grabComponent.release(entity);
                this.continuousComponent.stopContinuity(entity);
            } else if (this.grabComponent.getState() == GrabEntityComponent.GrabState.IDLE && this.grabComponent.grabNearest(entity, 4.5f, 2.0f, false)) {
                this.grabComponent.triggerPulling(entity);
            } else {
                this.cooldownComponent.startCooldown(entity, 15.0f);
            }
        }
    }

    private boolean onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && !this.grabComponent.hasGrabbedEntity()) {
            if (this.grabComponent.grabManually(entity, target)) {
                this.grabComponent.startPulling(entity);
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.ANTI_KNOCKBACK.get(), 1));
            return false;
        }
        return true;
    }

    public void onPullStart(LivingEntity entity, IAbility ability) {
        this.continuousComponent.setThresholdTime(entity, 200.0f);
    }

    public void onPullEnd(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        if (this.grabComponent.canContinueGrab(entity)) {
            this.chargeComponent.startCharging(entity, 50.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.grabComponent.getState() != GrabEntityComponent.GrabState.GRABBED) {
                this.grabComponent.release(entity);
            }
            if (!this.grabComponent.canContinueGrab(entity)) {
                this.cooldownComponent.startCooldown(entity, 300.0f);
            }
        }
    }

    public void onChargeStart(LivingEntity entity, IAbility ability) {
        SunaHelper.drainLiquids((LivingEntity)this.grabComponent.getGrabbedEntity(), (int)((int)WyHelper.randomWithRange((int)0, (int)1)), (int)((int)WyHelper.randomWithRange((int)1, (int)3)), (int)((int)WyHelper.randomWithRange((int)0, (int)1)));
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        this.particleInterval.restartIntervalToZero();
    }

    public void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (AbilityLimits.cancelPartyTable(entity) || AbilityLimits.cancelOtatsumaki(entity) || AbilityLimits.cancelWhirlingMace(entity) || AbilityLimits.cancelSaiKuru(entity) || AbilityLimits.cancelVicousRoar(entity)) {
                this.chargeComponent.stopCharging(entity);
            }
            if (!super.canUse(entity).isFail() && this.grabComponent.canContinueGrab(entity)) {
                LivingEntity target = this.grabComponent.getGrabbedEntity();
                if (this.particleInterval.canTick()) {
                    WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)ModParticleEffects.DESERT_ENCIERRO.get()), (Entity)entity, (double)target.func_226277_ct_(), (double)target.func_226278_cu_(), (double)target.func_226281_cx_());
                }
                DamageSource source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m();
                this.dealDamageComponent.hurtTarget(entity, target, 2.0f, source);
            } else {
                this.chargeComponent.stopCharging(entity);
            }
        }
    }

    public void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (this.grabComponent.hasGrabbedEntity()) {
            DamageSource source;
            LivingEntity target = this.grabComponent.getGrabbedEntity();
            if (this.dealDamageComponent.hurtTarget(entity, target, 20.0f, source = ModDamageSource.causeAbilityDamage((LivingEntity)entity, (IAbility)this).setInternal().func_151518_m())) {
                target.func_195064_c(new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 300, 2, false, true));
                target.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1, false, false));
                target.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 1, false, false));
            }
            this.grabComponent.release(entity);
        }
        this.animationComponent.stop(entity);
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted((LivingEntity)entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 300.0f);
    }
}

