/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sniperextra;

import java.io.Serializable;
import net.MrMagicalCart.cartaddon.abilities.sniperextra.ReworkedHissatsuAbility;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.SpikeEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.TetsuBoshiProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ReworkedTetsuBoshiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"tetsu_boshi", (Pair[])new Pair[]{ImmutablePair.of((Object)"Fires a pellet that upon impact releases multiple small iron spikes on the ground", null)});
    private static final float COOLDOWN = 200.0f;
    public static final AbilityCore<ReworkedTetsuBoshiAbility> INSTANCE = new AbilityCore.Builder("Tetsu Boshi", AbilityCategory.STYLE, ReworkedTetsuBoshiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)200.0f), ContinuousComponent.getTooltip()}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET}).setUnlockCheck(ReworkedTetsuBoshiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this);
    private final BowTriggerComponent bowTriggerComponent = new BowTriggerComponent((IAbility)this).addShootEvent(this::shoot);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public ReworkedTetsuBoshiAbility(AbilityCore<ReworkedTetsuBoshiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.bowTriggerComponent, this.projectileComponent});
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    public boolean shoot(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            boolean isHitScan = ReworkedHissatsuAbility.checkHitScan(entity);
            this.projectileComponent.setHitScan(isHitScan);
            this.projectileComponent.shoot(entity, 5.0f, 0.5f);
            this.continuousComponent.stopContinuity(entity);
            this.cooldownComponent.startCooldown(entity, 200.0f);
            return true;
        }
        return false;
    }

    public TetsuBoshiProjectile createProjectile(LivingEntity entity) {
        TetsuBoshiProjectile proj = new TetsuBoshiProjectile(entity.field_70170_p, entity);
        proj.onBlockImpactEvent = (AbilityProjectileEntity.IOnBlockImpact & Serializable)hit -> {
            for (int i = 0; i < 60; ++i) {
                double offsetX = WyHelper.randomWithRange((int)-7, (int)7) + WyHelper.randomDouble();
                double offsetZ = WyHelper.randomWithRange((int)-7, (int)7) + WyHelper.randomDouble();
                SpikeEntity spike = new SpikeEntity(entity.field_70170_p);
                spike.func_70012_b((double)hit.func_177958_n() + offsetX, (double)(hit.func_177956_o() + 1), (double)hit.func_177952_p() + offsetZ, 180.0f, 0.0f);
                entity.field_70170_p.func_217376_c((Entity)spike);
            }
        };
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isSniper() && questProps.hasFinishedQuest(CartQuests.SNIPER_TRIAL_02);
    }
}

