/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sniperextra;

import java.util.Optional;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class ReworkedHissatsuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"mineminenomi", (String)"hissatsu", (Pair[])new Pair[]{ImmutablePair.of((Object)"Allows the next sniper ability to instantly hit the target", null)});
    private static final float COOLDOWN = 100.0f;
    public static final AbilityCore<ReworkedHissatsuAbility> INSTANCE = new AbilityCore.Builder("Hissatsu", AbilityCategory.STYLE, ReworkedHissatsuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f), ContinuousComponent.getTooltip()}).setUnlockCheck(ReworkedHissatsuAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(this::onEndContinuity);

    public ReworkedHissatsuAbility(AbilityCore<ReworkedHissatsuAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent});
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onEndContinuity(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f);
    }

    public static boolean checkHitScan(LivingEntity entity) {
        Optional<ReworkedHissatsuAbility> ReworkedHissatsuAbility2 = AbilityDataCapability.getLazy((LivingEntity)entity).resolve().map(props -> (ReworkedHissatsuAbility)props.getEquippedAbility(INSTANCE));
        boolean isHitScan = false;
        if (ReworkedHissatsuAbility2.isPresent() && (isHitScan = ReworkedHissatsuAbility2.get().isContinuous())) {
            ReworkedHissatsuAbility2.get().getComponent(ModAbilityKeys.CONTINUOUS).ifPresent(comp -> comp.stopContinuity(entity));
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 3.0f);
            return true;
        }
        return false;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isSniper() && questProps.hasFinishedQuest(CartQuests.SNIPER_TRIAL_03);
    }
}

