/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.sniperextra;

import net.MrMagicalCart.cartaddon.abilities.sniperextra.ReworkedHissatsuAbility;
import net.MrMagicalCart.cartaddon.entities.projectiles.sniperextra.PlantusShurikenProjectile;
import net.MrMagicalCart.cartaddon.init.CartQuests;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;

public class MidoriBoshiPlantusShurikenAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"midori_boshi_plantus_shuriken", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user fires two sharp plant shurikens that cause bleeding.", null)});
    private static final float COOLDOWN = 180.0f;
    public static final AbilityCore<MidoriBoshiPlantusShurikenAbility> INSTANCE = new AbilityCore.Builder("Midori Boshi: Plantus Shuriken", AbilityCategory.STYLE, MidoriBoshiPlantusShurikenAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)180.0f), ContinuousComponent.getTooltip()}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.BULLET, SourceType.SLASH}).setUnlockCheck(MidoriBoshiPlantusShurikenAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this);
    private final BowTriggerComponent bowTriggerComponent = new BowTriggerComponent((IAbility)this).addShootEvent(this::shoot);
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent((IAbility)this).addTriggerEvent(100, this::triggerRepeaterEvent).addStopEvent(100, this::stopRepeaterEvent);

    public MidoriBoshiPlantusShurikenAbility(AbilityCore<MidoriBoshiPlantusShurikenAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.bowTriggerComponent, this.projectileComponent, this.repeaterComponent});
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            this.continuousComponent.triggerContinuity(entity);
        }
    }

    public boolean shoot(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.start(entity, 2, 8);
            return true;
        }
        return false;
    }

    private void triggerRepeaterEvent(LivingEntity entity, IAbility ability) {
        boolean isHitScan = ReworkedHissatsuAbility.checkHitScan(entity);
        this.projectileComponent.setHitScan(isHitScan);
        this.projectileComponent.shoot(entity, 4.0f, 1.0f);
    }

    private void stopRepeaterEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    public PlantusShurikenProjectile createProjectile(LivingEntity entity) {
        PlantusShurikenProjectile proj = new PlantusShurikenProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get((PlayerEntity)player);
        return props.isSniper() && questProps.hasFinishedQuest(CartQuests.SNIPER_TRIAL_05);
    }
}

