/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.skyfolk;

import java.util.UUID;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.init.CartParticleEffects;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WarriorsSpiritAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"warriors_spirit", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user unlocks their potential as a Sky Folk, reducing incoming damage and increasing their stats. (Applies dizzy after use)", null)});
    private static final int HOLD_TIME = 500;
    private static final int MIN_COOLDOWN = 150;
    private static final int MAX_COOLDOWN = 650;
    public static final AbilityCore<WarriorsSpiritAbility> INSTANCE = new AbilityCore.Builder("Warrior's Spirit", AbilityCategory.RACIAL, WarriorsSpiritAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)500.0f), CooldownComponent.getTooltip((float)150.0f, (float)650.0f), ChangeStatsComponent.getTooltip()}).setUnlockCheck(WarriorsSpiritAbility::canUnlock).build();
    private static final AbilityAttributeModifier MOVEMENT = new AbilityAttributeModifier(UUID.fromString("b989e935-99be-4b98-a6ee-fe0314c15a85"), INSTANCE, "Warrior's Spirit Movement Modifier", 0.08, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier KNOCKBACK = new AbilityAttributeModifier(UUID.fromString("c1e9b9bf-8419-4f21-ac32-7997e0c0d1d4"), INSTANCE, "Warrior's Spirit Knockback Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK = new AbilityAttributeModifier(UUID.fromString("8b56f2b6-3c3a-470f-9f0b-78eb1e3673e8"), INSTANCE, "Warrior's Spirit Punch Damage Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED = new AbilityAttributeModifier(UUID.fromString("012b2813-1c63-4997-89cc-a4276223693d"), INSTANCE, "Warrior's Spirit Attack Speed Modifier", 0.3, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent((IAbility)this);
    protected final DamageTakenComponent damageTakenComponent;

    public WarriorsSpiritAbility(AbilityCore<WarriorsSpiritAbility> core) {
        super(core);
        this.isNew = true;
        this.damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent, this.damageTakenComponent});
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)MOVEMENT);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233824_g_, (AttributeModifier)KNOCKBACK);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.PUNCH_DAMAGE, (AttributeModifier)ATTACK);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 500.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.getContinueTime() % 2.0f == 0.0f && !entity.func_70644_a(Effects.field_76441_p) && !entity.func_70644_a((Effect)ModEffects.VANISH.get())) {
            WyHelper.spawnParticleEffect((ParticleEffect)((ParticleEffect)CartParticleEffects.WARRIORS_SPIRIT.get()), (Entity)entity, (double)entity.func_226277_ct_(), (double)entity.func_226278_cu_(), (double)entity.func_226281_cx_());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 150.0f + this.continuousComponent.getContinueTime();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 30, 0, false, false));
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous()) {
            if (damageSource == DamageSource.field_76379_h) {
                return 0.0f;
            }
            return damage * 0.9f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.SKY_FOLK);
        return race && props.getDoriki() >= 7500.0;
    }
}

