/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.skyfolk;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class SkyFolkPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final AttributeModifier SKY_FOLK_JUMP = new AttributeModifier(UUID.fromString("f5f05c35-fa2f-4f30-be42-eab732e89826"), "Sky Folk Jump Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SKY_FOLK_FALL = new AttributeModifier(UUID.fromString("4ca3e3d9-8f9b-45db-82e2-fb1801b8fbd9"), "Sky Folk Fall Resistance Bonus", 8.0, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> SKY_FOLK_CHECK = entity -> {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.SKY_FOLK);
        return race && props.getDoriki() >= 0.0;
    };
    public static final AbilityCore<SkyFolkPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder("Sky Folk Passive Bonuses", AbilityCategory.RACIAL, AbilityType.PASSIVE, SkyFolkPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).setUnlockCheck(SkyFolkPassiveBonusesAbility::canUnlock).build();

    public SkyFolkPassiveBonusesAbility(AbilityCore<SkyFolkPassiveBonusesAbility> core) {
        super(core);
        this.pushStaticAttribute((Attribute)ModAttributes.JUMP_HEIGHT.get(), SKY_FOLK_JUMP);
        this.pushStaticAttribute((Attribute)ModAttributes.FALL_RESISTANCE.get(), SKY_FOLK_FALL);
    }

    public Predicate<LivingEntity> getCheck() {
        return SKY_FOLK_CHECK;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.SKY_FOLK);
        return race && props.getDoriki() >= 0.0;
    }
}

