/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.skyfolk;

import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.MilkyDialProjectile;

public class MilkyDialAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"milky_dial", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user creates a road of solid clouds, which can be traversed on.", null)});
    private static final int COOLDOWN = 160;
    public static final AbilityCore<MilkyDialAbility> INSTANCE = new AbilityCore.Builder("Milky Dial", AbilityCategory.RACIAL, MilkyDialAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)160.0f)}).setUnlockCheck(MilkyDialAbility::canUnlock).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);

    public MilkyDialAbility(AbilityCore<MilkyDialAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.projectileComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private MilkyDialProjectile createProjectile(LivingEntity entity) {
        MilkyDialProjectile proj = new MilkyDialProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.SKY_FOLK);
        return race && props.getDoriki() >= 6000.0;
    }
}

