/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.skyfolk;

import java.util.List;
import net.MrMagicalCart.cartaddon.init.CartValues;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class FlyingKickAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"flying_kick", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges and launches a flying kick.", null)});
    private static final float COOLDOWN = 180.0f;
    private static final float DAMAGE = 30.0f;
    private static final float RANGE = 2.5f;
    public static final AbilityCore<FlyingKickAbility> INSTANCE = new AbilityCore.Builder("Flying Kick", AbilityCategory.RACIAL, FlyingKickAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, DealDamageComponent.getTooltip((float)30.0f), ChargeComponent.getTooltip((float)10.0f), ContinuousComponent.getTooltip((float)10.0f), CooldownComponent.getTooltip((float)180.0f), RangeComponent.getTooltip((float)2.5f, (RangeComponent.RangeType)RangeComponent.RangeType.LINE)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setUnlockCheck(FlyingKickAbility::canUnlock).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(this::onChargeStart).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final AnimationComponent animationComponent = new AnimationComponent((IAbility)this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private boolean hasFallDamage;

    public FlyingKickAbility(AbilityCore<FlyingKickAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(new AbilityComponent[]{this.damageTakenComponent, this.chargeComponent, this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.animationComponent, this.rangeComponent});
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (AbilityHelper.canUseMomentumAbilities((LivingEntity)entity) && !this.chargeComponent.isCharging() && !this.continuousComponent.isContinuous()) {
            this.chargeComponent.startCharging(entity, 5.0f);
        }
    }

    private void onChargeStart(LivingEntity entity, IAbility ability) {
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isFail()) {
                this.chargeComponent.stopCharging(entity);
            }
            AbilityHelper.slowEntityFall((LivingEntity)entity);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)0.0, (double)0.0, (double)0.0);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isSuccess()) {
                this.continuousComponent.startContinuity(entity, 12.5f);
            } else {
                this.continuousComponent.stopContinuity(entity);
            }
        }
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.hasFallDamage = false;
        this.animationComponent.start(entity, ModAnimations.PHOENIX_KICK);
        if (!entity.field_70170_p.field_72995_K) {
            this.hitTrackerComponent.clearHits();
            Vector3d movement = entity.func_70040_Z().func_72432_b();
            movement = entity.func_70090_H() ? movement.func_186678_a(5.0) : movement.func_186678_a(entity.func_233570_aj_() ? 4.5 : 4.0);
            if (entity.field_70125_A < -40.0f) {
                movement = movement.func_72441_c(0.0, -(movement.field_72448_b - movement.field_72448_b / 2.0), 0.0);
            }
            AbilityHelper.setDeltaMovement((Entity)entity, (double)movement.field_72450_a, (double)movement.field_72448_b, (double)movement.field_72449_c);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            if (super.canUse(entity).isFail()) {
                this.continuousComponent.stopContinuity(entity);
            } else if (entity.func_70089_S()) {
                List targets = this.rangeComponent.getTargetsInArea(entity, 2.5f);
                ModDamageSource source = ((AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity)).setFistDamage();
                targets.remove(entity);
                for (LivingEntity target : targets) {
                    if (!this.hitTrackerComponent.canHit((Entity)entity) || !this.dealDamageComponent.hurtTarget(entity, target, 30.0f, (DamageSource)source)) continue;
                    target.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 5, 0));
                }
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.hasFallDamage = true;
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity entity) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)entity);
        boolean race = props.getRace().equals((Object)CartValues.SKY_FOLK);
        return race && props.getDoriki() >= 500.0;
    }
}

