/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.shiro;

import java.util.UUID;
import java.util.function.Predicate;
import net.MrMagicalCart.cartaddon.init.CartAbilities;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveStatBonusAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModResources;

public class ShiroPassiveBonusesAbility
extends PassiveStatBonusAbility {
    private static final UUID SHIRO_ARMOR_BONUS = UUID.fromString("a62418b9-6fb0-4692-9c82-3fa73aef4277");
    private static final AttributeModifier SHIRO_KNOCKBACK_RESISTANCE = new AttributeModifier(UUID.fromString("ab58bb59-d2e9-4153-902a-ae2c8e8733b8"), "Shiro Armor Bonus", 2.0, AttributeModifier.Operation.ADDITION);
    private static final Predicate<LivingEntity> SHIRO_CHECK = entity -> DevilFruitCapability.get((LivingEntity)entity).hasDevilFruit(CartAbilities.SHIRO_SHIRO_NO_MI);
    public static final AbilityCore<ShiroPassiveBonusesAbility> INSTANCE = new AbilityCore.Builder("Shiro Passive Bonuses", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, ShiroPassiveBonusesAbility::new).setIcon(ModResources.PERK_ICON).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{ChangeStatsComponent.getTooltip()}).build();

    public ShiroPassiveBonusesAbility(AbilityCore<ShiroPassiveBonusesAbility> core) {
        super(core);
        this.pushStaticAttribute(Attributes.field_233820_c_, SHIRO_KNOCKBACK_RESISTANCE);
        this.pushDynamicAttribute(Attributes.field_233826_i_, entity -> this.getModifier((LivingEntity)entity));
    }

    private AttributeModifier getModifier(LivingEntity entity) {
        double bonus = this.getBonus(entity);
        return new AttributeModifier(SHIRO_ARMOR_BONUS, "Shiro Armor Bonus", bonus, AttributeModifier.Operation.ADDITION);
    }

    private double getBonus(LivingEntity entity) {
        if (EntityStatsCapability.get((LivingEntity)entity).getDoriki() >= 10000.0) {
            return 10.0;
        }
        double doriki = EntityStatsCapability.get((LivingEntity)entity).getDoriki();
        int armorBonus = (int)doriki / 1000;
        return armorBonus;
    }

    public Predicate<LivingEntity> getCheck() {
        return SHIRO_CHECK;
    }
}

