/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.shiro;

import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.shiro.BigFatherAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class KyassuruTankuAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"kyassuru_tanku", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user's legs into treads, increasing their movement speed.", null)});
    private static final int HOLD_TIME = 500;
    private static final int MIN_COOLDOWN = 200;
    private static final int MAX_COOLDOWN = 700;
    public static final AbilityCore<KyassuruTankuAbility> INSTANCE = new AbilityCore.Builder("Kyassuru Tanku", AbilityCategory.DEVIL_FRUITS, KyassuruTankuAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ContinuousComponent.getTooltip((float)500.0f), CooldownComponent.getTooltip((float)200.0f, (float)700.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier STEP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("f139d3ce-ac49-42d6-bb47-e93a6b89e44b"), INSTANCE, "Shiro Step Modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(UUID.fromString("f139d3ce-ac49-42d6-bb47-e93a6b89e44b"), INSTANCE, "Shiro Speed Modifier", 1.08, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier JUMP_MODIFIER = new AbilityAttributeModifier(UUID.fromString("f139d3ce-ac49-42d6-bb47-e93a6b89e44b"), INSTANCE, "Shiro Jump Modifier", -3.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChangeStatsComponent changeStatsComponent;
    private final MorphComponent morphComponent = new MorphComponent((IAbility)this);

    public KyassuruTankuAbility(AbilityCore<KyassuruTankuAbility> core) {
        super(core);
        this.changeStatsComponent = new ChangeStatsComponent((IAbility)this);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.changeStatsComponent, this.morphComponent});
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_MODIFIER);
        this.changeStatsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_MODIFIER);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 500.0f);
    }

    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.changeStatsComponent.applyModifiers(entity);
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        if (!KyassuruTankuAbility.hasBigFatherActive(abilityDataProps)) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KYASSURU_TANK.get());
        } else {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.BIG_FATHER_TREADS.get());
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        if (!KyassuruTankuAbility.hasBigFatherActive(abilityDataProps)) {
            this.morphComponent.startMorph(entity, (MorphInfo)CartMorphs.KYASSURU_TANK.get());
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)entity);
        this.morphComponent.stopMorph(entity);
        this.changeStatsComponent.removeModifiers(entity);
        float cooldown = 200.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public static boolean hasBigFatherActive(IAbilityData props) {
        Ability ability = (Ability)props.getEquippedAbility(BigFatherAbility.INSTANCE);
        boolean isActive = ability != null && ability.isContinuous();
        return isActive;
    }
}

