/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.shiro;

import net.MrMagicalCart.cartaddon.entities.projectiles.shiro.FireTankCannonProjectile;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;

public class FireTankCannonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"fire_tank_cannon", (Pair[])new Pair[]{ImmutablePair.of((Object)"While in Big Father form, the user charges and fires a huge cannon ball, destroying everything in its path.", null)});
    private static final float COOLDOWN = 1200.0f;
    public static final AbilityCore<FireTankCannonAbility> INSTANCE = new AbilityCore.Builder("Fire Tank Cannon", AbilityCategory.DEVIL_FRUITS, FireTankCannonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, ChargeComponent.getTooltip((float)60.0f), CooldownComponent.getTooltip((float)1200.0f)}).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent((IAbility)this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent;
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this).addStartEvent(100, this::startChargingEvent).addTickEvent(100, this::tickChargingEvent).addEndEvent(100, this::endChargingEvent);

    public FireTankCannonAbility(AbilityCore<FireTankCannonAbility> core) {
        super(core);
        this.isNew = true;
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.BIG_FATHER.get(), new MorphInfo[]{(MorphInfo)CartMorphs.BIG_FATHER_TREADS.get()});
        this.addComponents(new AbilityComponent[]{this.projectileComponent, this.requireMorphComponent, this.chargeComponent});
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!this.chargeComponent.isCharging()) {
            this.chargeComponent.startCharging(entity, 60.0f);
        }
    }

    private void startChargingEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187680_c, SoundCategory.PLAYERS, 10.0f, 1.0f);
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.getChargeTime() % 30.0f == 0.0f) {
            entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), SoundEvents.field_187680_c, SoundCategory.PLAYERS, 10.0f, 1.0f);
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 1.3f, 0.5f);
        this.cooldownComponent.startCooldown(entity, 1200.0f);
    }

    private FireTankCannonProjectile createProjectile(LivingEntity entity) {
        FireTankCannonProjectile proj = new FireTankCannonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

