/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.shiro;

import net.MrMagicalCart.cartaddon.abilities.shiro.ShiroHelper;
import net.MrMagicalCart.cartaddon.entities.projectiles.shiro.ShiroCannonBallProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class CannonFiringAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"cannon_firing", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user shoots cannon balls from within their body. While in \u00a7aBig Father\u00a7r mode, even more cannon balls are fired. (10% chance to use a cannon ball when firing)", null)});
    private static final TranslationTextComponent CANNON_FIRING_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.cartaddon.cannon_firing", (String)"Cannon Firing"));
    private static final TranslationTextComponent CANNON_BARRAGE_NAME = new TranslationTextComponent(WyRegistry.registerName((String)"ability.cartaddon.cannon_barrage", (String)"Cannon Barrage"));
    private static final ResourceLocation CANNON_FIRING_ICON = new ResourceLocation("cartaddon", "textures/abilities/cannon_firing.png");
    private static final ResourceLocation CANNON_BARRAGE_ICON = new ResourceLocation("cartaddon", "textures/abilities/cannon_barrage.png");
    private static final float NORMAL_COOLDOWN = 90.0f;
    private static final float BIG_FATHER_COOLDOWN = 150.0f;
    private static final float DAMAGE = 50.0f;
    public static final AbilityCore<CannonFiringAbility> INSTANCE = new AbilityCore.Builder("Cannon Firing", AbilityCategory.DEVIL_FRUITS, CannonFiringAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> CANNON_FIRING_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), DealDamageComponent.getTooltip((float)15.0f), CooldownComponent.getTooltip((float)90.0f)}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, (e, a) -> CANNON_BARRAGE_NAME.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), DealDamageComponent.getTooltip((float)4.25f), CooldownComponent.getTooltip((float)150.0f)}).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(new SourceType[]{SourceType.PHYSICAL, SourceType.INDIRECT}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true);
    private final AltModeComponent<ShiroHelper.Modes> altModeComponent = new AltModeComponent((IAbility)this, ShiroHelper.Modes.class, (Enum)ShiroHelper.Modes.NORMAL, true).addChangeModeEvent(this::onAltModeChange);
    private int projectileSpread;
    private float cooldown = 90.0f;
    private int triggers = 3;
    private int interval = 8;
    private int amountShotAtOnce = 1;
    private ItemStack cannonBalls = null;

    public CannonFiringAbility(AbilityCore<CannonFiringAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.altModeComponent});
        this.setCustomShootLogic(living -> {
            for (int i = 0; i < this.amountShotAtOnce; ++i) {
                this.projectileComponent.shootWithSpread(living, 3.0f, 0.0f, this.projectileSpread);
            }
        });
        this.addCanUseCheck(this::canUseAbility);
    }

    public int getMaxTriggers() {
        return this.triggers;
    }

    public int getTriggerInterval() {
        return this.interval;
    }

    public float getRepeaterCooldown() {
        return this.cooldown;
    }

    public AbilityProjectileEntity getProjectileFactory(LivingEntity entity) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        ShiroCannonBallProjectile projectile = null;
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
        } else {
            for (ItemStack itemStack : ItemsHelper.getAllInventoryItems((LivingEntity)entity)) {
                if (!itemStack.func_77973_b().equals(ModItems.CANNON_BALL.get())) continue;
                this.cannonBalls = itemStack;
                break;
            }
        }
        float projDmageReduction = 0.15f;
        this.projectileSpread = 0;
        if (ShiroHelper.hasBigFatherActive(props)) {
            projectile = new ShiroCannonBallProjectile(entity.field_70170_p, entity);
            this.projectileSpread = 3;
            projDmageReduction = 0.75f;
            this.amountShotAtOnce = 5;
        } else {
            projectile = new ShiroCannonBallProjectile(entity.field_70170_p, entity);
            this.amountShotAtOnce = 1;
        }
        if (this.cannonBalls != null && this.cannonBalls.func_190916_E() != 0 && !this.canUseAbility(entity, (IAbility)this).isFail()) {
            double ran = Math.random() * 100.0;
            if (ran < 10.0) {
                this.cannonBalls.func_190918_g(1);
            }
        } else {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS), Util.field_240973_b_);
            this.repeaterComponent.stop(entity);
            return null;
        }
        projectile.setDamage(projectile.getDamage() * (1.0f - projDmageReduction));
        projectile.setMaxLife((int)((double)projectile.getMaxLife() * 0.9));
        return projectile;
    }

    private AbilityUseResult canUseAbility(LivingEntity entity, IAbility ability) {
        return (!entity.func_184614_ca().func_190926_b() || ItemsHelper.countItemInInventory((LivingEntity)entity, (Item)((Item)ModItems.CANNON_BALL.get())) <= 0) && !entity.func_184614_ca().func_77973_b().equals(ModItems.CANNON_BALL.get()) ? AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST_OR_CANNONBALLS)) : AbilityUseResult.success();
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, ShiroHelper.Modes mode) {
        switch (mode) {
            case BIG_FATHER: {
                this.cooldown = 150.0f;
                this.triggers = 8;
                this.interval = 7;
                this.setDisplayIcon(CANNON_BARRAGE_ICON);
                break;
            }
            default: {
                this.cooldown = 90.0f;
                this.triggers = 3;
                this.interval = 8;
                this.setDisplayIcon(CANNON_FIRING_ICON);
            }
        }
    }

    public void switchNormal(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)ShiroHelper.Modes.NORMAL);
    }

    public void switchBigFather(LivingEntity entity) {
        this.altModeComponent.setMode(entity, (Enum)ShiroHelper.Modes.BIG_FATHER);
    }
}

