/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.shiro;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.MrMagicalCart.cartaddon.abilities.shiro.CannonFiringAbility;
import net.MrMagicalCart.cartaddon.abilities.shiro.KyassuruTankuAbility;
import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class BigFatherAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"big_father", (Pair[])new Pair[]{ImmutablePair.of((Object)"Transforms the user into a mobile fortress with immense fire power and defense.", null)});
    public static final AbilityCore<BigFatherAbility> INSTANCE = new AbilityCore.Builder("Big Father", AbilityCategory.DEVIL_FRUITS, BigFatherAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)700.0f), ChangeStatsComponent.getTooltip()}).build();
    private static final AbilityAttributeModifier SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_MOVEMENT_SPEED_UUID, INSTANCE, "Big Father Speed Modifier", -0.75, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final AbilityAttributeModifier ARMOR_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_UUID, INSTANCE, "Big Father Armor Modifier", 24.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier ATTACK_SPEED_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_SPEED_UUID, INSTANCE, "Big Father Attack Speed Modifier", -0.2, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier JUMP_BOOST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_JUMP_BOOST_UUID, INSTANCE, "Big Father Jump Modifier", -3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier ARMOR_TOUGHNESS_MODIFIER;
    private static final AbilityAttributeModifier FALL_RESISTANCE_MODIFIER;
    private static final AbilityAttributeModifier STEP_ASSIST_MODIFIER;
    private static final AbilityAttributeModifier MAX_HEALTH_MODIFIER;
    private static final AbilityAttributeModifier KNOCKBACK_RESISTANCE_MODIFIER;
    private static final AbilityAttributeModifier REACH_MODIFIER;
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent((IAbility)this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final float MIN_COOLDOWN = 100.0f;
    private final float HOLDTIME = 3600.0f;

    public BigFatherAbility(AbilityCore<BigFatherAbility> core) {
        super(core);
        this.addCanUseCheck((entity, ability) -> {
            TranslationTextComponent text = new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{this.getDisplayName().getString(), KyassuruTankuAbility.INSTANCE.getUnlocalizedName()});
            return ((MorphInfo)CartMorphs.KYASSURU_TANK.get()).isActive(entity) ? AbilityUseResult.fail((ITextComponent)text) : AbilityUseResult.success();
        });
        Predicate<LivingEntity> isActive = entity -> this.morphComponent.isMorphed();
        this.addComponents(new AbilityComponent[]{this.damageTakenComponent});
        this.statsComponent.addAttributeModifier(Attributes.field_233821_d_, (AttributeModifier)SPEED_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)ARMOR_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233825_h_, (AttributeModifier)ATTACK_SPEED_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.JUMP_HEIGHT, (AttributeModifier)JUMP_BOOST_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)ARMOR_TOUGHNESS_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.FALL_RESISTANCE, (AttributeModifier)FALL_RESISTANCE_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_ASSIST_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233818_a_, (AttributeModifier)MAX_HEALTH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier(Attributes.field_233820_c_, (AttributeModifier)KNOCKBACK_RESISTANCE_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ForgeMod.REACH_DISTANCE, (AttributeModifier)REACH_MODIFIER, isActive);
        this.statsComponent.addAttributeModifier((Supplier)ModAttributes.ATTACK_RANGE, (AttributeModifier)REACH_MODIFIER, isActive);
        this.continuousComponent.addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::stopContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, this.getTransformation());
        this.statsComponent.applyModifiers(entity);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CannonFiringAbility cannon = (CannonFiringAbility)props.getEquippedAbility(CannonFiringAbility.INSTANCE);
        if (cannon != null) {
            cannon.switchBigFather(entity);
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 3, false, false));
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        this.statsComponent.removeModifiers(entity);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)entity);
        CannonFiringAbility cannon = (CannonFiringAbility)props.getEquippedAbility(CannonFiringAbility.INSTANCE);
        if (cannon != null) {
            cannon.switchNormal(entity);
        }
        this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
    }

    public MorphInfo getTransformation() {
        return (MorphInfo)CartMorphs.BIG_FATHER.get();
    }

    public float getContinuityHoldTime() {
        return 3600.0f;
    }

    public float getCooldownTicks() {
        return 100.0f + this.continuousComponent.getContinueTime() / 6.0f;
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (AbilityHelper.isDodging((LivingEntity)entity)) {
            return damage;
        }
        if (this.continuousComponent.isContinuous()) {
            if (damageSource == DamageSource.field_76379_h) {
                return 0.0f;
            }
            return damage * 0.65f;
        }
        return damage;
    }

    static {
        ARMOR_TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ARMOR_TOUGHNESS_UUID, INSTANCE, "Big Father Armor Toughness Modifier", 5.0, AttributeModifier.Operation.ADDITION);
        TOUGHNESS_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_TOUGHNESS_UUID, INSTANCE, "Big Father Toughness Modifier", 5.0, AttributeModifier.Operation.ADDITION);
        FALL_RESISTANCE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_FALL_RESISTANCE_UUID, INSTANCE, "Big Father Fall Resistance Modifier", 20.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        STEP_ASSIST_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Big Father Step Assist Modifier", 5.0, AttributeModifier.Operation.ADDITION);
        MAX_HEALTH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_STEP_HEIGHT_UUID, INSTANCE, "Big Father Max Health Modifier", 50.0, AttributeModifier.Operation.ADDITION);
        KNOCKBACK_RESISTANCE_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_KNOCKBACK_RESISTANCE_UUID, INSTANCE, "Big Father Knockback Resistance Modifier", 3.0, AttributeModifier.Operation.ADDITION);
        REACH_MODIFIER = new AbilityAttributeModifier(AttributeHelper.MORPH_ATTACK_REACH_UUID, INSTANCE, "Big Father Reach Modifier", 16.0, AttributeModifier.Operation.ADDITION);
    }
}

