/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryutriceratops;

import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ThreePointChargeAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"three_point_charge", (Pair[])new Pair[]{ImmutablePair.of((Object)"The user charges quickly into targets at full speed with all three horns.", null)});
    private static final int COOLDOWN = 240;
    private static final int HOLD_TIME = 30;
    private static final float AREA_SIZE = 2.0f;
    private static final float DAMAGE = 30.0f;
    public static final AbilityCore<ThreePointChargeAbility> INSTANCE = new AbilityCore.Builder("Three Point Charge", AbilityCategory.DEVIL_FRUITS, ThreePointChargeAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)240.0f), ContinuousComponent.getTooltip((float)30.0f), DealDamageComponent.getTooltip((float)30.0f)}).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(new SourceType[]{SourceType.FIST}).setSourceType(new SourceType[]{SourceType.INTERNAL}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addEndEvent(100, this::stopContinuityEvent).addTickEvent(100, this::tickContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent((IAbility)this);
    private final RangeComponent rangeComponent = new RangeComponent((IAbility)this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent((IAbility)this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.TRICERATOPS_GUARD.get(), new MorphInfo[0]);

    public ThreePointChargeAbility(AbilityCore<ThreePointChargeAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.requireMorphComponent});
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)3.0, (double)3.0);
        AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)0.2, (double)speed.field_72449_c);
        entity.field_70170_p.func_184133_a((PlayerEntity)null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.continuousComponent.startContinuity(entity, 30.0f);
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        for (LivingEntity target : this.rangeComponent.getTargetsInArea(entity, 2.0f)) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
            Vector3d speed = WyHelper.propulsion((LivingEntity)entity, (double)3.0, (double)3.0);
            AbilityHelper.setDeltaMovement((Entity)entity, (double)speed.field_72450_a, (double)0.5, (double)speed.field_72449_c);
        }
    }
}

