/*
 * Decompiled with CFR 0.152.
 */
package net.MrMagicalCart.cartaddon.abilities.ryutriceratops;

import net.MrMagicalCart.cartaddon.init.CartMorphs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class HelicopterFrillsAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText((String)"cartaddon", (String)"helicopter_frills", (Pair[])new Pair[]{ImmutablePair.of((Object)"Makes the user fly using gravity on the ground below you.", null)});
    private static final int COOLDOWN = 600;
    private static final int HOLD_TIME = 600;
    public static final AbilityCore<HelicopterFrillsAbility> INSTANCE = new AbilityCore.Builder("Helicopter Frills", AbilityCategory.DEVIL_FRUITS, HelicopterFrillsAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()}).addAdvancedDescriptionLine(new AbilityDescriptionLine.IDescriptionLine[]{AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip((float)100.0f, (float)600.0f), ContinuousComponent.getTooltip((float)1000.0f)}).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private boolean stateChanged = false;
    private final RequireMorphComponent requireMorphComponent;

    public HelicopterFrillsAbility(AbilityCore<HelicopterFrillsAbility> core) {
        super(core);
        this.isNew = true;
        this.requireMorphComponent = new RequireMorphComponent((IAbility)this, (MorphInfo)CartMorphs.TRICERATOPS_HEAVY.get(), new MorphInfo[0]);
        this.addComponents(new AbilityComponent[]{this.continuousComponent, this.requireMorphComponent});
        this.addCanUseCheck((entity, ability) -> AbilityHelper.isInCreativeOrSpectator((LivingEntity)entity) ? AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_SUVIVAL_ONLY) : AbilityUseResult.success());
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1000.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75101_c = true;
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_70143_R = 0.0f;
            if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)player)) {
                if (player.field_71075_bZ.field_75101_c) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.field_71075_bZ.field_75100_b = false;
                    this.stateChanged = true;
                }
            } else if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75101_c = true;
                this.stateChanged = true;
            }
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
            boolean canFly = DevilFruitHelper.flyingAtMaxHeight((LivingEntity)player, (double)24.0);
            if (player.field_71075_bZ.field_75100_b) {
                DevilFruitHelper.vanillaFlightThreshold((LivingEntity)player, (int)(canFly ? 256 : (int)player.func_226278_cu_() - 1));
            }
            if (player.func_70051_ag()) {
                AbilityHelper.setDeltaMovement((Entity)player, (Vector3d)player.func_213322_ci().func_216372_d(0.69, 1.0, 0.69));
                player.func_70031_b(false);
                this.stateChanged = true;
            }
            if (this.stateChanged) {
                this.stateChanged = false;
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (!entity.field_70170_p.field_72995_K) {
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            }
        }
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime() / 2.0f);
    }
}

